/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.partitioner;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cassandra.spark.data.partitioner.CassandraRing;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.apache.cassandra.spark.utils.RangeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenPartitioner
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenPartitioner.class);
    public static final Serializer SERIALIZER = new Serializer();
    private List<Range<BigInteger>> subRanges;
    private CassandraRing ring;
    private transient RangeMap<BigInteger, Integer> partitionMap;
    private transient Map<Integer, Range<BigInteger>> reversePartitionMap;

    protected TokenPartitioner(List<Range<BigInteger>> subRanges, CassandraRing ring) {
        this.subRanges = subRanges;
        this.ring = ring;
        this.partitionMap = TreeRangeMap.create();
        this.reversePartitionMap = new HashMap<Integer, Range<BigInteger>>();
        this.calculateTokenRangeMap();
    }

    public TokenPartitioner(CassandraRing ring, int defaultParallelism, int numCores) {
        this(ring, defaultParallelism, numCores, false);
    }

    public TokenPartitioner(CassandraRing ring, int defaultParallelism, int numCores, boolean shuffle) {
        LOGGER.info("Creating TokenPartitioner defaultParallelism={} numCores={}", (Object)defaultParallelism, (Object)numCores);
        this.partitionMap = TreeRangeMap.create();
        this.reversePartitionMap = new HashMap<Integer, Range<BigInteger>>();
        this.ring = ring;
        int numSplits = TokenPartitioner.calculateSplits(ring, defaultParallelism, numCores);
        this.subRanges = ring.rangeMap().asMapOfRanges().keySet().stream().flatMap(tr -> RangeUtils.split((Range<BigInteger>)tr, numSplits).stream()).collect(Collectors.toList());
        if (shuffle) {
            Collections.shuffle(this.subRanges);
        }
        this.calculateTokenRangeMap();
    }

    private void calculateTokenRangeMap() {
        int nextPartitionId = 0;
        for (Range<BigInteger> tr : this.subRanges) {
            int partitionId = nextPartitionId++;
            this.partitionMap.put(tr, (Object)partitionId);
            this.reversePartitionMap.put(partitionId, tr);
        }
        this.validateMapSizes();
        this.validateCompleteRangeCoverage();
        this.validateRangesDoNotOverlap();
        LOGGER.info("Number of partitions {}", (Object)this.reversePartitionMap.size());
        LOGGER.info("Partition map " + String.valueOf(this.partitionMap));
        LOGGER.info("Reverse partition map " + String.valueOf(this.reversePartitionMap));
    }

    private static int calculateSplits(CassandraRing ring, int defaultParallelism, Integer cores) {
        int tasksToRun = Math.max(cores, defaultParallelism);
        LOGGER.info("Tasks to run: {}", (Object)tasksToRun);
        Map rangeListMap = ring.rangeMap().asMapOfRanges();
        LOGGER.info("Initial ranges: {}", (Object)rangeListMap);
        int ranges = rangeListMap.size();
        LOGGER.info("Number of ranges: {}", (Object)ranges);
        int calculatedSplits = TokenPartitioner.divCeil(tasksToRun, ranges);
        LOGGER.info("Calculated number of splits as {}", (Object)calculatedSplits);
        return calculatedSplits;
    }

    public CassandraRing ring() {
        return this.ring;
    }

    public List<Range<BigInteger>> subRanges() {
        return this.subRanges;
    }

    public RangeMap<BigInteger, Integer> partitionMap() {
        return this.partitionMap;
    }

    public Map<Integer, Range<BigInteger>> reversePartitionMap() {
        return this.reversePartitionMap;
    }

    private static int divCeil(int a, int b) {
        return (a + b - 1) / b;
    }

    public int numPartitions() {
        return this.reversePartitionMap.size();
    }

    public boolean isInPartition(BigInteger token, ByteBuffer key, int partitionId) {
        boolean isInPartition;
        boolean bl = isInPartition = partitionId == (Integer)this.partitionMap.get((Comparable)token);
        if (LOGGER.isDebugEnabled() && !isInPartition) {
            Range<BigInteger> range = this.getTokenRange(partitionId);
            LOGGER.debug("Filtering out partition key key='{}' token={} rangeLower={} rangeUpper={}", new Object[]{ByteBufferUtils.toHexString(key), token, range.lowerEndpoint(), range.upperEndpoint()});
        }
        return isInPartition;
    }

    public Range<BigInteger> getTokenRange(int partitionId) {
        return this.reversePartitionMap.get(partitionId);
    }

    private void validateRangesDoNotOverlap() {
        List sortedRanges = this.partitionMap.asMapOfRanges().keySet().stream().sorted(Comparator.comparing(Range::lowerEndpoint)).collect(Collectors.toList());
        Range previous = null;
        for (Range current : sortedRanges) {
            if (previous != null) {
                Preconditions.checkState((!current.isConnected(previous) || current.intersection(previous).isEmpty() ? 1 : 0) != 0, (String)"Two ranges in partition map are overlapping %s %s", (Object[])new Object[]{previous, current});
            }
            previous = current;
        }
    }

    private void validateCompleteRangeCoverage() {
        TreeRangeSet missingRangeSet = TreeRangeSet.create();
        missingRangeSet.add(Range.closed((Comparable)this.ring.partitioner().minToken(), (Comparable)this.ring.partitioner().maxToken()));
        this.partitionMap.asMapOfRanges().keySet().forEach(arg_0 -> ((RangeSet)missingRangeSet).remove(arg_0));
        List missingRanges = missingRangeSet.asRanges().stream().filter(Range::isEmpty).collect(Collectors.toList());
        Preconditions.checkState((boolean)missingRanges.isEmpty(), (Object)("There should be no missing ranges, but found " + missingRanges.toString()));
    }

    private void validateMapSizes() {
        int nrPartitions = this.numPartitions();
        Preconditions.checkState((nrPartitions == this.partitionMap.asMapOfRanges().keySet().size() ? 1 : 0) != 0, (Object)String.format("Number of partitions %d not matching with partition map size %d", nrPartitions, this.partitionMap.asMapOfRanges().keySet().size()));
        Preconditions.checkState((nrPartitions == this.reversePartitionMap.keySet().size() ? 1 : 0) != 0, (Object)String.format("Number of partitions %d not matching with reverse partition map size %d", nrPartitions, this.reversePartitionMap.keySet().size()));
        Preconditions.checkState((nrPartitions >= this.ring.rangeMap().asMapOfRanges().keySet().size() ? 1 : 0) != 0, (Object)String.format("Number of partitions %d supposed to be more than number of token ranges %d", nrPartitions, this.ring.rangeMap().asMapOfRanges().keySet().size()));
        Preconditions.checkState((nrPartitions >= this.ring.tokenRanges().keySet().size() ? 1 : 0) != 0, (Object)String.format("Number of partitions %d supposed to be more than number of instances %d", nrPartitions, this.ring.tokenRanges().keySet().size()));
        Preconditions.checkState((this.partitionMap.asMapOfRanges().keySet().size() == this.reversePartitionMap.keySet().size() ? 1 : 0) != 0, (Object)String.format("You must be kidding me! Partition map %d and reverse map %d are not of same size", this.partitionMap.asMapOfRanges().keySet().size(), this.reversePartitionMap.keySet().size()));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        LOGGER.debug("Falling back to JDK deserialization");
        this.partitionMap = TreeRangeMap.create();
        this.reversePartitionMap = new HashMap<Integer, Range<BigInteger>>();
        this.ring = (CassandraRing)in.readObject();
        this.subRanges = (List)in.readObject();
        this.calculateTokenRangeMap();
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        LOGGER.debug("Falling back to JDK serialization");
        out.writeObject(this.ring);
        out.writeObject(this.subRanges);
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<TokenPartitioner> {
        public void write(Kryo kryo, Output out, TokenPartitioner partitioner) {
            out.writeInt(partitioner.subRanges.size());
            for (Range<BigInteger> subRange : partitioner.subRanges) {
                out.writeByte(subRange.lowerBoundType() == BoundType.OPEN ? 1 : 0);
                out.writeString(((BigInteger)subRange.lowerEndpoint()).toString());
                out.writeByte(subRange.upperBoundType() == BoundType.OPEN ? 1 : 0);
                out.writeString(((BigInteger)subRange.upperEndpoint()).toString());
            }
            kryo.writeObject(out, (Object)partitioner.ring);
        }

        public TokenPartitioner read(Kryo kryo, Input in, Class<TokenPartitioner> type) {
            int numRanges = in.readInt();
            ArrayList<Range<BigInteger>> subRanges = new ArrayList<Range<BigInteger>>(numRanges);
            for (int range = 0; range < numRanges; ++range) {
                BoundType lowerBoundType = in.readByte() == 1 ? BoundType.OPEN : BoundType.CLOSED;
                BigInteger lowerBound = new BigInteger(in.readString());
                BoundType upperBoundType = in.readByte() == 1 ? BoundType.OPEN : BoundType.CLOSED;
                BigInteger upperBound = new BigInteger(in.readString());
                subRanges.add((Range<BigInteger>)Range.range((Comparable)lowerBound, (BoundType)lowerBoundType, (Comparable)upperBound, (BoundType)upperBoundType));
            }
            return new TokenPartitioner(subRanges, (CassandraRing)kryo.readObject(in, CassandraRing.class));
        }
    }
}

