/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class EmbeddableValidator
extends ConfigurationNodeValidator {
    EmbeddableValidator() {
    }

    void validate(Embeddable embeddable, ValidationResult validationResult) {
        DataChannelDescriptor domain;
        String name = embeddable.getClassName();
        if (Util.isEmptyString(name)) {
            this.addFailure(validationResult, embeddable, "Unnamed Embeddable", new Object[0]);
            return;
        }
        DataMap map = embeddable.getDataMap();
        if (map == null) {
            return;
        }
        for (Embeddable otherEmb : map.getEmbeddables()) {
            if (otherEmb == embeddable || !name.equals(otherEmb.getClassName())) continue;
            this.addFailure(validationResult, embeddable, "Duplicate Embeddable class name: %s", name);
            break;
        }
        if ((domain = map.getDataChannelDescriptor()) != null) {
            for (DataMap nextMap : domain.getDataMaps()) {
                Embeddable conflictingEmbeddable;
                if (nextMap == map || (conflictingEmbeddable = nextMap.getEmbeddable(name)) == null || conflictingEmbeddable == embeddable) continue;
                this.addFailure(validationResult, embeddable, "Duplicate Embeddable name in another DataMap: %s", name);
                break;
            }
        }
    }
}

