/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen.xml;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.project.extension.BaseSaverDelegate;
import org.apache.cayenne.util.XMLSerializable;

public class CgenSaverDelegate
extends BaseSaverDelegate {
    private DataChannelMetaData metaData;

    CgenSaverDelegate(DataChannelMetaData metaData) {
        this.metaData = metaData;
    }

    public Void visitDataMap(DataMap dataMap) {
        CgenConfiguration cgen = (CgenConfiguration)this.metaData.get((ConfigurationNode)dataMap, CgenConfiguration.class);
        if (cgen != null) {
            CgenSaverDelegate.resolveOutputDir(this.getBaseDirectory().getURL(), cgen);
            this.encoder.nested((XMLSerializable)cgen, (ConfigurationNodeVisitor)this.getParentDelegate());
        }
        return null;
    }

    static void resolveOutputDir(URL baseURL, CgenConfiguration cgenConfiguration) {
        Path prevPath;
        Path oldRoot;
        Path resourcePath;
        if (baseURL == null) {
            return;
        }
        try {
            resourcePath = Paths.get(baseURL.toURI());
        }
        catch (URISyntaxException e) {
            throw new CayenneRuntimeException("Unable to resolve output path", (Throwable)e, new Object[0]);
        }
        if (Files.isRegularFile(resourcePath, new LinkOption[0])) {
            resourcePath = resourcePath.getParent();
        }
        if ((oldRoot = cgenConfiguration.getRootPath()) == null) {
            cgenConfiguration.setRootPath(resourcePath);
        }
        if ((prevPath = cgenConfiguration.buildPath()) != null) {
            Path superTemplatePath;
            Path templatePath;
            if (prevPath.isAbsolute()) {
                Path relPath = prevPath;
                if (resourcePath.getRoot().equals(prevPath.getRoot())) {
                    relPath = resourcePath.relativize(prevPath).normalize();
                }
                cgenConfiguration.setRelPath(relPath);
            }
            if ((templatePath = Paths.get(cgenConfiguration.getTemplate(), new String[0])).isAbsolute()) {
                cgenConfiguration.setTemplate(resourcePath.relativize(templatePath).normalize().toString());
            }
            if ((superTemplatePath = Paths.get(cgenConfiguration.getSuperTemplate(), new String[0])).isAbsolute()) {
                cgenConfiguration.setSuperTemplate(resourcePath.relativize(superTemplatePath).normalize().toString());
            }
        }
        cgenConfiguration.setRootPath(resourcePath);
    }
}

