/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.net.URL;
import org.apache.commons.beanutils2.converters.URLConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class URLConverterTest {
    private URLConverter converter;

    @BeforeEach
    public void before() {
        this.converter = new URLConverter();
    }

    @Test
    public void testSimpleConversion() {
        String[] input;
        for (String urlString : input = new String[]{"http://www.apache.org", "http://www.apache.org/", "ftp://cvs.apache.org", "file://project.xml", "http://208.185.179.12", "http://www.apache.org:9999/test/thing", "http://user:admin@www.apache.org:50/one/two.three", "http://notreal.apache.org", "http://notreal.apache.org/test/file.xml#\u8ba1\u7b97\u673a\u56fe\u5f62\u5b66", "http://notreal.apache.org/test/file.xml#%E8%AE%A1%E7%AE%97%E6%9C%BA%E5%9B%BE%E5%BD%A2%E5%AD%A6"}) {
            Assertions.assertEquals((Object)urlString, (Object)((URL)this.converter.convert(URL.class, (Object)urlString)).toString(), (String)"from String to URL");
            Assertions.assertEquals((Object)urlString, (Object)this.converter.convert(null, (Object)urlString).toString(), (String)"from String to null type");
        }
    }
}

