/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.XMLPropertiesConfiguration;
import org.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.combined.ConfigurationDeclaration;
import org.apache.commons.configuration2.builder.combined.FileExtensionConfigurationBuilderProvider;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestFileExtensionConfigurationBuilderProvider {
    private static final String DEF_CLASS = PropertiesConfiguration.class.getName();
    private static final String MATCH_CLASS = XMLPropertiesConfiguration.class.getName();
    private static final String EXT = "xml";

    private static FileExtensionConfigurationBuilderProvider setUpProvider() {
        return new FileExtensionConfigurationBuilderProvider(BasicConfigurationBuilder.class.getName(), null, MATCH_CLASS, DEF_CLASS, EXT, null);
    }

    private ConfigurationDeclaration setUpDecl() {
        return (ConfigurationDeclaration)Mockito.mock(ConfigurationDeclaration.class);
    }

    @Test
    void testDetermineConfigurationClassExtensionMatch() throws ConfigurationException {
        ConfigurationDeclaration decl = this.setUpDecl();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl().setPath("C:\\Test\\someTestConfiguration.xml");
        FileExtensionConfigurationBuilderProvider provider = TestFileExtensionConfigurationBuilderProvider.setUpProvider();
        Assertions.assertEquals((Object)MATCH_CLASS, (Object)provider.determineConfigurationClass(decl, Collections.singleton(params)));
    }

    @Test
    void testDetermineConfigurationClassExtensionNoMatch() throws ConfigurationException {
        ConfigurationDeclaration decl = this.setUpDecl();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl().setPath("C:\\Test\\someTestConfiguration.properties");
        FileExtensionConfigurationBuilderProvider provider = TestFileExtensionConfigurationBuilderProvider.setUpProvider();
        Assertions.assertEquals((Object)DEF_CLASS, (Object)provider.determineConfigurationClass(decl, Collections.singleton(params)));
    }

    @Test
    void testDetermineConfigurationClassMatchCase() throws ConfigurationException {
        ConfigurationDeclaration decl = this.setUpDecl();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl().setPath("C:\\Test\\someTestConfiguration." + StringUtils.toRootUpperCase((String)EXT));
        FileExtensionConfigurationBuilderProvider provider = TestFileExtensionConfigurationBuilderProvider.setUpProvider();
        Assertions.assertEquals((Object)MATCH_CLASS, (Object)provider.determineConfigurationClass(decl, Collections.singleton(params)));
    }

    @Test
    void testDetermineConfigurationClassNoExtension() throws ConfigurationException {
        ConfigurationDeclaration decl = this.setUpDecl();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl().setPath("C:\\Test\\someTestConfiguration");
        FileExtensionConfigurationBuilderProvider provider = TestFileExtensionConfigurationBuilderProvider.setUpProvider();
        Assertions.assertEquals((Object)DEF_CLASS, (Object)provider.determineConfigurationClass(decl, Collections.singleton(params)));
    }

    @Test
    void testDetermineConfigurationClassNoParams() throws ConfigurationException {
        ConfigurationDeclaration decl = this.setUpDecl();
        FileExtensionConfigurationBuilderProvider provider = TestFileExtensionConfigurationBuilderProvider.setUpProvider();
        Assertions.assertEquals((Object)DEF_CLASS, (Object)provider.determineConfigurationClass(decl, new ArrayList()));
    }

    @Test
    void testDeterminieConfigurationClassNoFileName() throws ConfigurationException {
        ConfigurationDeclaration decl = this.setUpDecl();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        FileExtensionConfigurationBuilderProvider provider = TestFileExtensionConfigurationBuilderProvider.setUpProvider();
        Assertions.assertEquals((Object)DEF_CLASS, (Object)provider.determineConfigurationClass(decl, Collections.singleton(params)));
    }

    @Test
    void testInitNoDefaultConfigClass() {
        String builderClass = BasicConfigurationBuilder.class.getName();
        Assertions.assertThrows(IllegalArgumentException.class, () -> new FileExtensionConfigurationBuilderProvider(builderClass, null, MATCH_CLASS, null, EXT, null));
    }

    @Test
    void testInitNoExt() {
        String builderClass = BasicConfigurationBuilder.class.getName();
        Assertions.assertThrows(IllegalArgumentException.class, () -> new FileExtensionConfigurationBuilderProvider(builderClass, null, MATCH_CLASS, DEF_CLASS, null, null));
    }

    @Test
    void testInitNoMatchingConfigClass() {
        String builderClass = BasicConfigurationBuilder.class.getName();
        Assertions.assertThrows(IllegalArgumentException.class, () -> new FileExtensionConfigurationBuilderProvider(builderClass, null, null, DEF_CLASS, EXT, null));
    }

    @Test
    void testInitSuper() {
        FileExtensionConfigurationBuilderProvider provider = new FileExtensionConfigurationBuilderProvider(BasicConfigurationBuilder.class.getName(), ReloadingFileBasedConfigurationBuilder.class.getName(), MATCH_CLASS, DEF_CLASS, EXT, null);
        Assertions.assertEquals((Object)BasicConfigurationBuilder.class.getName(), (Object)provider.getBuilderClass());
        Assertions.assertEquals((Object)ReloadingFileBasedConfigurationBuilder.class.getName(), (Object)provider.getReloadingBuilderClass());
        Assertions.assertEquals((Object)DEF_CLASS, (Object)provider.getConfigurationClass());
    }
}

