/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.color;

public final class ColorXyz {
    public static final ColorXyz BLACK = new ColorXyz(0.0, 0.0, 0.0);
    public static final ColorXyz WHITE = new ColorXyz(95.05, 100.0, 108.9);
    public static final ColorXyz RED = new ColorXyz(41.24, 21.26, 1.93);
    public static final ColorXyz GREEN = new ColorXyz(35.76, 71.52, 11.92);
    public static final ColorXyz BLUE = new ColorXyz(18.05, 7.22, 95.05);
    public final double x;
    public final double y;
    public final double z;

    public ColorXyz(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorXyz colorXyz = (ColorXyz)o;
        if (Double.compare(colorXyz.x, this.x) != 0) {
            return false;
        }
        if (Double.compare(colorXyz.y, this.y) != 0) {
            return false;
        }
        return Double.compare(colorXyz.z, this.z) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        return 31 * result + (int)(temp ^ temp >>> 32);
    }

    public String toString() {
        return "{X: " + this.x + ", Y: " + this.y + ", Z: " + this.z + "}";
    }
}

