/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.UriParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UriParserTest {
    private static final String[] schemes = new String[]{"ftp", "file"};

    private void checkNormalizedPath(String path, String normalized) throws FileSystemException {
        StringBuilder pathBuilder = new StringBuilder(path);
        UriParser.fixSeparators((StringBuilder)pathBuilder);
        UriParser.normalisePath((StringBuilder)pathBuilder);
        Assertions.assertEquals((Object)normalized, (Object)pathBuilder.toString());
    }

    @Test
    public void testColonInFileName() {
        Assertions.assertNull((Object)UriParser.extractScheme((String)"some/path/some:file"));
    }

    @Test
    public void testColonInFileNameAndNotSupportedScheme() {
        Assertions.assertNull((Object)UriParser.extractScheme((String[])schemes, (String)"some:file"));
    }

    @Test
    public void testColonInFileNameWithPath() {
        Assertions.assertNull((Object)UriParser.extractScheme((String[])schemes, (String)"some/path/some:file"));
    }

    @Test
    public void testColonNotFollowedBySlash() {
        Assertions.assertEquals((Object)"file", (Object)UriParser.extractScheme((String[])schemes, (String)"file:user/subdir/some/path/some:file"));
    }

    @Test
    public void testIPv6CheckUriEncoding() throws FileSystemException {
        UriParser.checkUriEncoding((String)"http://[fe80::14b5:1204:5410:64ca%en1]:8080");
    }

    @Test
    public void testNormalScheme() {
        Assertions.assertEquals((Object)"ftp", (Object)UriParser.extractScheme((String[])schemes, (String)"ftp://user:pass@host/some/path/some:file"));
    }

    @Test
    public void testNormalSchemeWithBuffer() {
        StringBuilder buffer = new StringBuilder();
        UriParser.extractScheme((String[])schemes, (String)"ftp://user:pass@host/some/path/some:file", (StringBuilder)buffer);
        Assertions.assertEquals((Object)"//user:pass@host/some/path/some:file", (Object)buffer.toString());
    }

    @Test
    public void testOneSlashScheme() {
        Assertions.assertEquals((Object)"file", (Object)UriParser.extractScheme((String[])schemes, (String)"file:/user:pass@host/some/path/some:file"));
    }

    @Test
    public void testOneSlashSchemeWithBuffer() {
        StringBuilder buffer = new StringBuilder();
        UriParser.extractScheme((String[])schemes, (String)"file:/user:pass@host/some/path/some:file", (StringBuilder)buffer);
        Assertions.assertEquals((Object)"/user:pass@host/some/path/some:file", (Object)buffer.toString());
    }

    @Test
    public void testPathOfNormalizedPath() throws FileSystemException {
        this.checkNormalizedPath("./Sub Folder/", "Sub Folder");
        this.checkNormalizedPath("./Sub Folder/../", "");
        this.checkNormalizedPath("./Sub Folder%2f..%2f", "");
        this.checkNormalizedPath("File.txt", "File.txt");
        this.checkNormalizedPath("./Sub Folder/./File.txt", "Sub Folder/File.txt");
        this.checkNormalizedPath("./Sub Folder%2F.%2FFile.txt", "Sub Folder/File.txt");
    }

    @Test
    public void testTypeOfNormalizedPath() {
        try {
            Assertions.assertEquals((Object)FileType.FOLDER, (Object)UriParser.normalisePath((StringBuilder)new StringBuilder("")));
            Assertions.assertEquals((Object)FileType.FOLDER, (Object)UriParser.normalisePath((StringBuilder)new StringBuilder("/")));
            Assertions.assertEquals((Object)FileType.FOLDER, (Object)UriParser.normalisePath((StringBuilder)new StringBuilder(".")));
            Assertions.assertEquals((Object)FileType.FOLDER, (Object)UriParser.normalisePath((StringBuilder)new StringBuilder("./")));
            Assertions.assertEquals((Object)FileType.FOLDER, (Object)UriParser.normalisePath((StringBuilder)new StringBuilder("./Sub Folder/")));
            Assertions.assertEquals((Object)FileType.FOLDER, (Object)UriParser.normalisePath((StringBuilder)new StringBuilder("./Sub Folder/.")));
            Assertions.assertEquals((Object)FileType.FOLDER, (Object)UriParser.normalisePath((StringBuilder)new StringBuilder("./Sub Folder/./")));
            Assertions.assertEquals((Object)FileType.FILE, (Object)UriParser.normalisePath((StringBuilder)new StringBuilder("File.txt")));
            Assertions.assertEquals((Object)FileType.FILE, (Object)UriParser.normalisePath((StringBuilder)new StringBuilder("/File.txt")));
            Assertions.assertEquals((Object)FileType.FILE, (Object)UriParser.normalisePath((StringBuilder)new StringBuilder("./File.txt")));
            Assertions.assertEquals((Object)FileType.FILE, (Object)UriParser.normalisePath((StringBuilder)new StringBuilder("./Sub Folder/File.txt")));
            Assertions.assertEquals((Object)FileType.FILE, (Object)UriParser.normalisePath((StringBuilder)new StringBuilder("./Sub Folder/./File.txt")));
            Assertions.assertEquals((Object)FileType.FILE, (Object)UriParser.normalisePath((StringBuilder)new StringBuilder("./Sub Folder/./File.")));
            Assertions.assertEquals((Object)FileType.FILE, (Object)UriParser.normalisePath((StringBuilder)new StringBuilder("./Sub Folder/./File..")));
        }
        catch (FileSystemException e) {
            Assertions.fail((Throwable)e);
        }
    }
}

