/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.zip;

import java.io.File;
import junit.framework.Test;
import org.apache.commons.vfs2.AbstractProviderTestConfig;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.ProviderTestSuite;
import org.apache.commons.vfs2.VfsTestUtils;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.zip.ZipFileProvider;

public class ZipProviderTestCase
extends AbstractProviderTestConfig {
    public static Test suite() throws Exception {
        return new ProviderTestSuite(new ZipProviderTestCase(), true);
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        File zipFile = VfsTestUtils.getTestResource("test.zip");
        String uri = "zip:file:" + zipFile.getAbsolutePath() + "!/";
        return manager.resolveFile(uri);
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("zip", (FileProvider)new ZipFileProvider());
        manager.addExtensionMap("zip", "zip");
        manager.addMimeTypeMap("application/zip", "zip");
    }
}

