/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.nio.file.AccessMode;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RandomAccessModeTest {
    @Test
    public void testFromAccessMode() {
        Assertions.assertEquals((Object)RandomAccessMode.READ, (Object)RandomAccessMode.from((AccessMode[])new AccessMode[]{AccessMode.READ}));
        Assertions.assertEquals((Object)RandomAccessMode.READ, (Object)RandomAccessMode.from((AccessMode[])new AccessMode[]{AccessMode.READ, AccessMode.READ}));
        Assertions.assertEquals((Object)RandomAccessMode.READ, (Object)RandomAccessMode.from((AccessMode[])new AccessMode[]{AccessMode.READ, AccessMode.READ, AccessMode.EXECUTE}));
        Assertions.assertEquals((Object)RandomAccessMode.READWRITE, (Object)RandomAccessMode.from((AccessMode[])new AccessMode[]{AccessMode.WRITE}));
        Assertions.assertEquals((Object)RandomAccessMode.READWRITE, (Object)RandomAccessMode.from((AccessMode[])new AccessMode[]{AccessMode.WRITE, AccessMode.WRITE}));
        Assertions.assertEquals((Object)RandomAccessMode.READWRITE, (Object)RandomAccessMode.from((AccessMode[])new AccessMode[]{AccessMode.WRITE, AccessMode.READ}));
        Assertions.assertEquals((Object)RandomAccessMode.READWRITE, (Object)RandomAccessMode.from((AccessMode[])new AccessMode[]{AccessMode.READ, AccessMode.WRITE}));
        Assertions.assertEquals((Object)RandomAccessMode.READWRITE, (Object)RandomAccessMode.from((AccessMode[])new AccessMode[]{AccessMode.WRITE, AccessMode.WRITE, AccessMode.EXECUTE}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomAccessMode.from((AccessMode[])new AccessMode[]{AccessMode.EXECUTE}));
    }

    @Test
    public void testGetModeStringRead() {
        Assertions.assertEquals((Object)"r", (Object)RandomAccessMode.READ.getModeString());
    }

    @Test
    public void testGetModeStringReadWrite() {
        Assertions.assertEquals((Object)"rw", (Object)RandomAccessMode.READWRITE.getModeString());
    }

    @Test
    public void testRead() {
        Assertions.assertTrue((boolean)RandomAccessMode.READ.requestRead());
        Assertions.assertFalse((boolean)RandomAccessMode.READ.requestWrite());
    }

    @Test
    public void testReadWrite() {
        Assertions.assertTrue((boolean)RandomAccessMode.READWRITE.requestRead());
        Assertions.assertTrue((boolean)RandomAccessMode.READWRITE.requestWrite());
    }

    @Test
    public void testToAccessModes() {
        Assertions.assertArrayEquals((Object[])new AccessMode[]{AccessMode.READ}, (Object[])RandomAccessMode.READ.toAccessModes());
        Assertions.assertArrayEquals((Object[])new AccessMode[]{AccessMode.READ, AccessMode.WRITE}, (Object[])RandomAccessMode.READWRITE.toAccessModes());
    }
}

