/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.apache.rat.OptionCollection;
import org.apache.rat.commandline.Arg;
import org.apache.rat.tools.AntOption;
import org.apache.rat.tools.MavenGenerator;
import org.apache.rat.utils.CasedString;

public final class AntGenerator {
    private static final List<Option> ANT_FILTER_LIST = new ArrayList<Option>();
    private static final Predicate<Option> ANT_FILTER;
    private static final Map<String, String> RENAME_MAP;

    private AntGenerator() {
    }

    public static Predicate<Option> getFilter() {
        return ANT_FILTER;
    }

    public static void main(String[] args) throws IOException {
        if (args == null || args.length < 3) {
            System.err.println("At least three arguments are required: package, simple class name, target directory.");
            return;
        }
        String packageName = args[0];
        String className = args[1];
        String destDir = args[2];
        List<AntOption> options = Arg.getOptions().getOptions().stream().filter(ANT_FILTER).map(AntOption::new).collect(Collectors.toList());
        String pkgName = String.join((CharSequence)File.separator, new CasedString(CasedString.StringCase.DOT, packageName).getSegments());
        File file = new File(new File(new File(destDir), pkgName), className + ".java");
        file.getParentFile().mkdirs();
        try (InputStream template = AntGenerator.class.getResourceAsStream("/Ant.tpl");
             FileWriter writer = new FileWriter(file);
             ByteArrayOutputStream bos = new ByteArrayOutputStream();
             OutputStreamWriter customClasses = new OutputStreamWriter(bos);){
            if (template == null) {
                throw new RuntimeException("Template /Ant.tpl not found");
            }
            LineIterator iter = IOUtils.lineIterator(new InputStreamReader(template, StandardCharsets.UTF_8));
            block43: while (iter.hasNext()) {
                String line = iter.next();
                switch (line.trim()) {
                    case "${static}": {
                        for (Map.Entry<String, String> entry : RENAME_MAP.entrySet()) {
                            writer.append(String.format("        xlateName.put(\"%s\", \"%s\");%n", entry.getKey(), entry.getValue()));
                        }
                        for (Option option : ANT_FILTER_LIST) {
                            writer.append(String.format("        unsupportedArgs.add(\"%s\");%n", StringUtils.defaultIfEmpty(option.getLongOpt(), option.getOpt())));
                        }
                        continue block43;
                    }
                    case "${methods}": {
                        AntGenerator.writeMethods(writer, options, customClasses);
                        break;
                    }
                    case "${package}": {
                        writer.append(String.format("package %s;%n", packageName));
                        break;
                    }
                    case "${constructor}": {
                        writer.append(String.format("    protected %s() {}%n", className));
                        break;
                    }
                    case "${class}": {
                        writer.append(String.format("public abstract class %s extends Task {%n", className));
                        break;
                    }
                    case "${classes}": {
                        customClasses.flush();
                        customClasses.close();
                        writer.write(bos.toString());
                        break;
                    }
                    case "${commonArgs}": {
                        InputStream argsTpl = MavenGenerator.class.getResourceAsStream("/Args.tpl");
                        try {
                            if (argsTpl == null) {
                                throw new RuntimeException("Args.tpl not found");
                            }
                            IOUtils.copy(argsTpl, (Writer)writer, StandardCharsets.UTF_8);
                            continue block43;
                        }
                        finally {
                            if (argsTpl == null) continue block43;
                            argsTpl.close();
                            continue block43;
                        }
                    }
                    default: {
                        writer.append(line).append(System.lineSeparator());
                    }
                }
            }
        }
    }

    private static void writeMethods(FileWriter writer, List<AntOption> options, Writer customClasses) throws IOException {
        for (AntOption option : options) {
            if (option.isAttribute()) {
                writer.append(option.getComment(true));
                writer.append(String.format("    public void %s {%n%s%n    }%n%n", option.getAttributeFunctionName(), AntGenerator.getAttributeBody(option)));
            }
            if (!option.isElement()) continue;
            customClasses.append(option.getComment(false));
            customClasses.append(String.format("    public %1$s create%1$s() {%n        return new %1$s();%n    }%n%n", WordUtils.capitalize(option.getName())));
            customClasses.append(AntGenerator.getElementClass(option));
        }
    }

    private static String getAttributeBody(AntOption option) {
        return option.hasArg() ? String.format("        setArg(%s, %s);%n", option.keyValue(), option.getName()) : String.format("        if (%1$s) { setArg(%2$s, null); } else { removeArg(%2$s); }", option.getName(), option.keyValue());
    }

    private static String getElementClass(AntOption option) {
        return String.format("    public class %1$s extends Child { %1$s() {super(%2$s);}}%n%n", WordUtils.capitalize(option.getName()), option.keyValue());
    }

    static String createName(Option option) {
        String name = option.getLongOpt();
        name = StringUtils.defaultIfEmpty(RENAME_MAP.get(name), name).toLowerCase(Locale.ROOT);
        return new CasedString(CasedString.StringCase.KEBAB, name).toCase(CasedString.StringCase.CAMEL);
    }

    static {
        ANT_FILTER_LIST.addAll(Arg.LOG_LEVEL.group().getOptions());
        ANT_FILTER_LIST.addAll(Arg.DIR.group().getOptions());
        ANT_FILTER_LIST.add(OptionCollection.HELP);
        ANT_FILTER = option -> !ANT_FILTER_LIST.contains(option) && option.getLongOpt() != null;
        RENAME_MAP = new HashMap<String, String>();
        RENAME_MAP.put("addLicense", "add-license");
    }
}

