/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.PDPDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameIDFormatFilter
extends AbstractInitializableComponent
implements MetadataFilter {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(NameIDFormatFilter.class);
    private boolean removeExistingFormats;
    @Nonnull
    @NonnullElements
    private Multimap<Predicate<EntityDescriptor>, String> applyMap;
    @Nonnull
    private final SAMLObjectBuilder<NameIDFormat> formatBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameIDFormat.DEFAULT_ELEMENT_NAME);

    public void setRemoveExistingFormats(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.removeExistingFormats = flag;
    }

    public void setRules(@Nonnull @NonnullElements Map<Predicate<EntityDescriptor>, Collection<String>> rules) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(rules, (String)"Rules map cannot be null");
        this.applyMap = ArrayListMultimap.create((int)rules.size(), (int)1);
        for (Map.Entry<Predicate<EntityDescriptor>, Collection<String>> entry : rules.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.applyMap.putAll(entry.getKey(), (Iterable)StringSupport.normalizeStringCollection(entry.getValue()));
        }
    }

    @Nullable
    public XMLObject filter(@Nullable XMLObject metadata) throws FilterException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (metadata == null) {
            return null;
        }
        if (metadata instanceof EntitiesDescriptor) {
            this.filterEntitiesDescriptor((EntitiesDescriptor)metadata);
        } else {
            this.filterEntityDescriptor((EntityDescriptor)metadata);
        }
        return metadata;
    }

    protected void filterEntityDescriptor(@Nonnull EntityDescriptor descriptor) {
        for (Map.Entry entry : this.applyMap.asMap().entrySet()) {
            if (((Collection)entry.getValue()).isEmpty() || !((Predicate)entry.getKey()).apply((Object)descriptor)) continue;
            for (RoleDescriptor role : descriptor.getRoleDescriptors()) {
                this.filterRoleDescriptor(role, (Collection)entry.getValue());
            }
        }
    }

    protected void filterRoleDescriptor(@Nonnull RoleDescriptor role, @Nonnull @NonnullElements Collection<String> formats) {
        List roleFormats;
        if (role instanceof SPSSODescriptor) {
            roleFormats = ((SPSSODescriptor)role).getNameIDFormats();
        } else if (role instanceof AttributeAuthorityDescriptor) {
            roleFormats = ((AttributeAuthorityDescriptor)role).getNameIDFormats();
        } else if (role instanceof PDPDescriptor) {
            roleFormats = ((PDPDescriptor)role).getNameIDFormats();
        } else {
            return;
        }
        if (this.removeExistingFormats && !roleFormats.isEmpty()) {
            this.log.debug("Removing existing NameIDFormats from {} role in EntityDescriptor '{}'", (Object)role.getElementQName(), (Object)((EntityDescriptor)role.getParent()).getEntityID());
            roleFormats.clear();
        }
        for (String format : formats) {
            NameIDFormat nif = (NameIDFormat)this.formatBuilder.buildObject();
            nif.setFormat(format);
            this.log.info("Adding NameIDFormat '{}' to EntityDescriptor '{}'", (Object)format, (Object)((EntityDescriptor)role.getParent()).getEntityID());
            roleFormats.add(nif);
        }
    }

    protected void filterEntitiesDescriptor(@Nonnull EntitiesDescriptor descriptor) {
        for (EntitiesDescriptor group : descriptor.getEntitiesDescriptors()) {
            this.filterEntitiesDescriptor(group);
        }
        for (EntityDescriptor entity : descriptor.getEntityDescriptors()) {
            this.filterEntityDescriptor(entity);
        }
    }
}

