/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.client;

import java.net.MalformedURLException;
import java.net.URI;
import org.apache.cxf.jaxrs.client.WebClient;

public class HttpRequestProperties {
    private String hostName;
    private int port;
    private String httpMethod;
    private String requestPath;
    private String requestQuery;

    public HttpRequestProperties(WebClient wc, String httpMethod) {
        this(wc.getCurrentURI(), httpMethod);
    }

    public HttpRequestProperties(URI uri, String httpMethod) {
        this(uri.getHost(), HttpRequestProperties.getPortFromURI(uri), httpMethod, uri.getRawPath(), uri.getRawQuery());
    }

    public HttpRequestProperties(String hostName, int port, String httpMethod, String requestPath) {
        this(hostName, port, httpMethod, requestPath, null);
    }

    public HttpRequestProperties(String hostName, int port, String httpMethod, String requestPath, String requestQuery) {
        this.requestPath = requestPath;
        this.hostName = hostName;
        this.port = port;
        this.httpMethod = httpMethod;
        this.requestQuery = requestQuery;
    }

    private static int getPortFromURI(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            try {
                port = uri.toURL().getDefaultPort();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return port;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public String getRequestQuery() {
        return this.requestQuery;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }
}

