/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.File;
import java.util.concurrent.Semaphore;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.impl.CleaningActivateCallback;
import org.apache.activemq.artemis.core.server.impl.FileBasedNodeManager;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public final class InVMNodeManager
extends FileBasedNodeManager {
    private final Semaphore primaryLock;
    private final Semaphore backupLock;
    public volatile State state = State.NOT_STARTED;
    public long failoverPause = 0L;

    public InVMNodeManager(boolean replicatedBackup) {
        this(replicatedBackup, null);
        if (replicatedBackup) {
            throw new RuntimeException("if replicated-backup, we need its journal directory");
        }
    }

    public InVMNodeManager(boolean replicatedBackup, File directory) {
        super(replicatedBackup, directory);
        this.primaryLock = new Semaphore(1);
        this.backupLock = new Semaphore(1);
        this.setUUID(UUIDGenerator.getInstance().generateUUID());
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStarted()) {
            return;
        }
        super.start();
        this.readNodeActivationSequence();
    }

    @Override
    public void awaitPrimaryNode() throws InterruptedException {
        while (true) {
            if (this.state == State.NOT_STARTED) {
                Thread.sleep(10L);
                continue;
            }
            this.primaryLock.acquire();
            if (this.state == State.PAUSED) {
                this.primaryLock.release();
                Thread.sleep(10L);
                continue;
            }
            if (this.state == State.FAILING_BACK) {
                this.primaryLock.release();
                Thread.sleep(10L);
                continue;
            }
            if (this.state == State.ACTIVE) break;
        }
        if (this.failoverPause > 0L) {
            Thread.sleep(this.failoverPause);
        }
    }

    @Override
    public void awaitActiveStatus() throws InterruptedException {
        while (this.state != State.ACTIVE) {
            Thread.sleep(10L);
        }
    }

    @Override
    public void startBackup() throws InterruptedException {
        this.backupLock.acquire();
    }

    @Override
    public ActivateCallback startPrimaryNode() throws InterruptedException {
        this.state = State.FAILING_BACK;
        this.primaryLock.acquire();
        return new CleaningActivateCallback(){

            @Override
            public void activationComplete() {
                InVMNodeManager.this.state = State.ACTIVE;
            }
        };
    }

    @Override
    public void pausePrimaryServer() {
        this.state = State.PAUSED;
        this.primaryLock.release();
    }

    @Override
    public void crashPrimaryServer() {
        this.primaryLock.release();
    }

    @Override
    public boolean isAwaitingFailback() {
        return this.state == State.FAILING_BACK;
    }

    @Override
    public boolean isBackupActive() {
        return this.primaryLock.availablePermits() == 0;
    }

    @Override
    public void interrupt() {
    }

    @Override
    public void releaseBackup() {
        this.backupLock.release();
    }

    @Override
    public SimpleString readNodeId() {
        return this.getNodeId();
    }

    public static enum State {
        ACTIVE,
        PAUSED,
        FAILING_BACK,
        NOT_STARTED;

    }
}

