/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.jgroups.protocols.RED;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.UNICAST3;
import org.jgroups.protocols.pbcast.NAKACK2;
import org.jgroups.stack.Policy;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.ShutdownRejectedExecutionHandler;

public class CheckForAbsenceOfRED
implements Policy {
    protected static final Class<? extends Protocol> UNICAST3 = UNICAST3.class;
    protected static final Class<? extends Protocol> NAKACK2 = NAKACK2.class;
    protected static final Class<? extends Protocol> RED = RED.class;

    @Override
    public void check(Protocol prot) throws Exception {
        if (!(prot instanceof TP)) {
            throw new IllegalStateException(String.format("%s needs to be run in the scope of a transport", CheckForAbsenceOfRED.class.getSimpleName()));
        }
        ProtocolStack stack = prot.getProtocolStack();
        if ((stack.findProtocol(UNICAST3) == null || stack.findProtocol(NAKACK2) == null) && stack.findProtocol(RED) != null) {
            String e = String.format("found %s: when either %s or %s are missing, this can lead to message loss. Please remove %s", RED.getSimpleName(), UNICAST3.getSimpleName(), NAKACK2.getSimpleName(), RED.getSimpleName());
            throw new IllegalStateException(e);
        }
    }

    protected static boolean isCallerRunsHandler(RejectedExecutionHandler h) {
        return h instanceof ThreadPoolExecutor.CallerRunsPolicy || h instanceof ShutdownRejectedExecutionHandler && ((ShutdownRejectedExecutionHandler)h).handler() instanceof ThreadPoolExecutor.CallerRunsPolicy;
    }
}

