/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.ws.handler.Handler;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.jaxws.handler.BaseHandlerChainBuilder;
import org.apache.cxf.jaxws.handler.DelegatingHandlerChainBuilder;
import org.apache.cxf.jaxws.handler.JakartaeeToJavaeeAdaptor;
import org.apache.cxf.jaxws.handler.jakartaee.PortComponentHandlerType;
import org.w3c.dom.Element;

final class JakartaeeHandlerChainBuilder
extends BaseHandlerChainBuilder {
    static final String JAKARTAEE_NS = "https://jakarta.ee/xml/ns/jakartaee";
    private static JAXBContext context;
    private final DelegatingHandlerChainBuilder delegate;

    JakartaeeHandlerChainBuilder(ResourceBundle bundle, URL handlerFileURL, DelegatingHandlerChainBuilder delegate) {
        super(bundle, handlerFileURL);
        this.delegate = delegate;
    }

    public List<Handler> build(Element el, QName portQName, QName serviceQName, String bindingID) {
        return this.build(JAKARTAEE_NS, el, portQName, serviceQName, bindingID);
    }

    @Override
    void processHandlerElement(Element el, List<Handler> chain) {
        try {
            JAXBContext ctx = JakartaeeHandlerChainBuilder.getContextForPortComponentHandlerType();
            PortComponentHandlerType pt = (PortComponentHandlerType)JAXBUtils.unmarshall((JAXBContext)ctx, (Element)el, PortComponentHandlerType.class).getValue();
            chain.addAll(this.delegate.buildHandlerChain(JakartaeeToJavaeeAdaptor.of(pt)));
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Could not unmarshal handler chain", e);
        }
    }

    private static synchronized JAXBContext getContextForPortComponentHandlerType() throws JAXBException {
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{PortComponentHandlerType.class});
        }
        return context;
    }
}

