/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io.processors.charset;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.HashMap;
import org.apache.daffodil.io.LocalBufferMixin;
import org.apache.daffodil.io.processors.charset.BitsCharset;
import org.apache.daffodil.io.processors.charset.BitsCharsetDecoder;
import org.apache.daffodil.io.processors.charset.BitsCharsetEncoder;
import org.apache.daffodil.io.processors.charset.BitsCharsetNonByteSize;
import org.apache.daffodil.io.processors.charset.DecoderInfo;
import org.apache.daffodil.io.processors.charset.DecoderInfo$;
import org.apache.daffodil.io.processors.charset.EncoderInfo;
import org.apache.daffodil.io.processors.charset.EncoderInfo$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.MaybeInt;
import org.apache.daffodil.lib.util.MaybeInt$;
import scala.Float$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public interface EncoderDecoderMixin
extends LocalBufferMixin {
    public static void $init$(EncoderDecoderMixin $this) {
    }

    public static HashMap org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$decoderCache$(EncoderDecoderMixin $this) {
        return $this.org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$decoderCache();
    }

    default public HashMap<BitsCharset, DecoderInfo> org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$decoderCache() {
        return new HashMap<BitsCharset, DecoderInfo>();
    }

    public static HashMap org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$encoderCache$(EncoderDecoderMixin $this) {
        return $this.org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$encoderCache();
    }

    default public HashMap<BitsCharset, EncoderInfo> org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$encoderCache() {
        return new HashMap<BitsCharset, EncoderInfo>();
    }

    private Tuple2<Object, MaybeInt> derivations(BitsCharset charset) {
        Tuple2 tuple2;
        BitsCharset bitsCharset = charset;
        if (bitsCharset instanceof BitsCharsetNonByteSize) {
            BitsCharsetNonByteSize nbsc = (BitsCharsetNonByteSize)bitsCharset;
            int encodingMandatoryAlignmentInBits = 1;
            long maybeCharWidthInBits = MaybeInt$.MODULE$.apply(nbsc.bitWidthOfACodeUnit());
            tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)encodingMandatoryAlignmentInBits), (Object)new MaybeInt(maybeCharWidthInBits));
        } else {
            int encodingMandatoryAlignmentInBits = 8;
            BitsCharsetEncoder encoder = charset.newEncoder();
            float maxBytes = encoder.maxBytesPerChar();
            if (maxBytes == encoder.averageBytesPerChar()) {
                long maybeCharWidthInBits = MaybeInt$.MODULE$.apply((int)(maxBytes * (float)8));
                tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)encodingMandatoryAlignmentInBits), (Object)new MaybeInt(maybeCharWidthInBits));
            } else {
                long maybeCharWidthInBits = MaybeInt$.MODULE$.Nope();
                tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)encodingMandatoryAlignmentInBits), (Object)new MaybeInt(maybeCharWidthInBits));
            }
        }
        Tuple2 tuple = tuple2;
        return tuple;
    }

    public static BitsCharsetDecoder getDecoder$(EncoderDecoderMixin $this, BitsCharset charset) {
        return $this.getDecoder(charset);
    }

    default public BitsCharsetDecoder getDecoder(BitsCharset charset) {
        return this.getDecoderInfo(charset).coder();
    }

    public static DecoderInfo getDecoderInfo$(EncoderDecoderMixin $this, BitsCharset charset) {
        return $this.getDecoderInfo(charset);
    }

    default public DecoderInfo getDecoderInfo(BitsCharset charset) {
        DecoderInfo entry = this.org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$decoderCache().get(charset);
        if (entry == null) {
            BitsCharsetDecoder coder = charset.newDecoder();
            Tuple2<Object, MaybeInt> tuple2 = this.derivations(charset);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int encodingMandatoryAlignmentInBits = BoxesRunTime.unboxToInt((Object)tuple2._1());
            long maybeCharWidthInBits = tuple2._2() == null ? BoxesRunTime.unboxToLong(null) : ((MaybeInt)tuple2._2()).__v();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)encodingMandatoryAlignmentInBits), (Object)new MaybeInt(maybeCharWidthInBits));
            int encodingMandatoryAlignmentInBits2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
            long maybeCharWidthInBits2 = tuple22._2() == null ? BoxesRunTime.unboxToLong(null) : ((MaybeInt)tuple22._2()).__v();
            entry = DecoderInfo$.MODULE$.apply(coder, encodingMandatoryAlignmentInBits2, maybeCharWidthInBits2);
            this.org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$decoderCache().put(charset, entry);
        }
        return entry;
    }

    public static BitsCharsetEncoder getEncoder$(EncoderDecoderMixin $this, BitsCharset charset) {
        return $this.getEncoder(charset);
    }

    default public BitsCharsetEncoder getEncoder(BitsCharset charset) {
        return this.getEncoderInfo(charset).coder();
    }

    public static EncoderInfo getEncoderInfo$(EncoderDecoderMixin $this, BitsCharset charset) {
        return $this.getEncoderInfo(charset);
    }

    default public EncoderInfo getEncoderInfo(BitsCharset charset) {
        EncoderInfo entry = this.org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$encoderCache().get(charset);
        if (entry == null) {
            BitsCharsetEncoder coder = charset.newEncoder();
            BitsCharsetEncoder replacingCoder = charset.newEncoder();
            BitsCharsetEncoder reportingCoder = charset.newEncoder();
            replacingCoder.onMalformedInput(CodingErrorAction.REPLACE);
            replacingCoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            reportingCoder.onMalformedInput(CodingErrorAction.REPORT);
            reportingCoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            Tuple2<Object, MaybeInt> tuple2 = this.derivations(charset);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int encodingMandatoryAlignmentInBits = BoxesRunTime.unboxToInt((Object)tuple2._1());
            long maybeCharWidthInBits = tuple2._2() == null ? BoxesRunTime.unboxToLong(null) : ((MaybeInt)tuple2._2()).__v();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)encodingMandatoryAlignmentInBits), (Object)new MaybeInt(maybeCharWidthInBits));
            int encodingMandatoryAlignmentInBits2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
            long maybeCharWidthInBits2 = tuple22._2() == null ? BoxesRunTime.unboxToLong(null) : ((MaybeInt)tuple22._2()).__v();
            entry = EncoderInfo$.MODULE$.apply(coder, replacingCoder, reportingCoder, encodingMandatoryAlignmentInBits2, maybeCharWidthInBits2);
            this.org$apache$daffodil$io$processors$charset$EncoderDecoderMixin$$encoderCache().put(charset, entry);
        }
        return entry;
    }

    public static long lengthInBits$(EncoderDecoderMixin $this, String str, BitsCharset bitsCharset) {
        return $this.lengthInBits(str, bitsCharset);
    }

    default public long lengthInBits(String str, BitsCharset bitsCharset) {
        if (str.length() == 0) {
            return 0L;
        }
        long mew = bitsCharset.maybeFixedWidth();
        if (MaybeInt$.MODULE$.isDefined$extension(mew)) {
            int w = MaybeInt$.MODULE$.get$extension(mew);
            return Int$.MODULE$.int2long(w * str.length());
        }
        return BoxesRunTime.unboxToLong(this.withLocalByteBuffer().apply((Function1 & Serializable)lbb -> BoxesRunTime.unboxToLong(this.withLocalCharBuffer().apply((Function1 & Serializable)cbb -> {
            ByteBuffer bb;
            block9: {
                CoderResult coderResult;
                CoderResult cr;
                block10: {
                    CoderResult coderResult2;
                    CoderResult coderResult3;
                    block8: {
                        CharBuffer cb = (CharBuffer)cbb.getBuf(Int$.MODULE$.int2long(str.length()));
                        cb.append(str);
                        cb.flip();
                        BitsCharsetEncoder encoder = this.getEncoder(bitsCharset);
                        encoder.reset();
                        long nBytes = (long)package$.MODULE$.ceil(Float$.MODULE$.float2double((float)str.length() * encoder.maxBytesPerChar()));
                        bb = (ByteBuffer)lbb.getBuf(nBytes);
                        coderResult = cr = encoder.encode(cb, bb, true);
                        coderResult3 = CoderResult.UNDERFLOW;
                        coderResult2 = coderResult;
                        if (coderResult3 != null) break block8;
                        if (coderResult2 == null) break block9;
                        break block10;
                    }
                    if (coderResult3.equals(coderResult2)) break block9;
                }
                CoderResult coderResult4 = CoderResult.OVERFLOW;
                CoderResult coderResult5 = coderResult;
                if (!(coderResult4 != null ? !coderResult4.equals(coderResult5) : coderResult5 != null)) {
                    throw Assert$.MODULE$.invariantFailed("byte buffer wasn't big enough to accomodate the string");
                }
                if (cr.isMalformed()) {
                    cr.throwException();
                } else if (cr.isUnmappable()) {
                    cr.throwException();
                } else {
                    throw new MatchError((Object)coderResult);
                }
            }
            bb.flip();
            int lengthInBytes = bb.remaining();
            return Int$.MODULE$.int2long(lengthInBytes * 8);
        }))));
    }

    public static String truncateToBits$(EncoderDecoderMixin $this, String str, BitsCharset bitsCharset, long nBits) {
        return $this.truncateToBits(str, bitsCharset, nBits);
    }

    default public String truncateToBits(String str, BitsCharset bitsCharset, long nBits) {
        if (nBits < 0L) {
            throw Assert$.MODULE$.usageError("nBits.>=(0)");
        }
        if (str.length() == 0) {
            return str;
        }
        if (nBits == 0L) {
            return "";
        }
        long mew = bitsCharset.maybeFixedWidth();
        if (MaybeInt$.MODULE$.isDefined$extension(mew)) {
            int w = MaybeInt$.MODULE$.get$extension(mew);
            long nChars = nBits / (long)w;
            if (nChars > (long)str.length()) {
                return str;
            }
            return str.substring(0, (int)nChars);
        }
        return (String)this.withLocalByteBuffer().apply((Function1 & Serializable)lbb -> {
            long nBytes = nBits / 8L;
            ByteBuffer bb = (ByteBuffer)lbb.getBuf(nBytes);
            return (String)this.withLocalCharBuffer().apply((Function1 & Serializable)cbb -> {
                String string;
                CoderResult cr;
                CharBuffer cb = (CharBuffer)cbb.getBuf(Int$.MODULE$.int2long(str.length()));
                cb.append(str);
                cb.flip();
                BitsCharsetEncoder encoder = this.getEncoder(bitsCharset);
                encoder.reset();
                CoderResult coderResult = cr = encoder.encode(cb, bb, true);
                CoderResult coderResult2 = CoderResult.UNDERFLOW;
                CoderResult coderResult3 = coderResult;
                if (!(coderResult2 != null ? !coderResult2.equals(coderResult3) : coderResult3 != null)) {
                    string = str;
                } else {
                    CoderResult coderResult4 = CoderResult.OVERFLOW;
                    CoderResult coderResult5 = coderResult;
                    if (!(coderResult4 != null ? !coderResult4.equals(coderResult5) : coderResult5 != null)) {
                        String truncString;
                        cb.flip();
                        string = truncString = cb.toString();
                    } else {
                        if (cr.isMalformed() || cr.isUnmappable()) {
                            cr.throwException();
                            throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
                        }
                        throw new MatchError((Object)coderResult);
                    }
                }
                String truncString = string;
                return truncString;
            });
        });
    }
}

