/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer.om;

import java.util.ArrayList;
import java.util.List;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementName;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.templates.TorqueSchemaAttributeName;
import org.apache.torque.templates.TorqueSchemaElementName;
import org.apache.torque.templates.transformer.om.FindHelper;
import org.apache.torque.templates.transformer.om.TableChildElementName;

public class OMReferencingForeignKeyTableTransformer {
    public void transform(SourceElement table, ControllerState controllerState) throws SourceTransformerException {
        SourceElement database = table.getParent();
        String tableName = (String)table.getAttribute(TorqueSchemaAttributeName.NAME.getName());
        ArrayList<SourceElement> referencingForeignKeys = new ArrayList<SourceElement>();
        for (SourceElement otherTable : database.getChildren(TorqueSchemaElementName.TABLE.getName())) {
            List<SourceElement> referencingFromOtherTable = FindHelper.findForeignKeyByReferencedTable(otherTable, tableName);
            referencingForeignKeys.addAll(referencingFromOtherTable);
        }
        SourceElement referencingForeignKeysElement = new SourceElement((SourceElementName)TableChildElementName.REFERENCING_FOREIGN_KEYS);
        table.getChildren().add(referencingForeignKeysElement);
        for (SourceElement foreignKey : referencingForeignKeys) {
            referencingForeignKeysElement.getChildren().add(foreignKey);
        }
    }
}

