/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.List;
import org.apache.torque.Column;
import org.apache.torque.ColumnImpl;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.criteria.SqlEnum;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.mapper.BigDecimalMapper;
import org.apache.torque.util.BasePeerImpl;
import org.apache.torque.util.UniqueList;
import org.apache.torque.util.functions.Avg;

public class AvgHelper {
    public BigDecimal avg(Criteria c, String columnName) throws TorqueException {
        return this.avg(c, null, columnName, null);
    }

    public BigDecimal avg(Criteria c, Column column) throws TorqueException {
        return this.avg(c, column.getSqlExpression());
    }

    public BigDecimal avg(Criteria c, Connection conn, Column column) throws TorqueException {
        return this.avg(c, conn, column.getSqlExpression(), null);
    }

    public BigDecimal avg(Criteria c, Connection conn, String columnName, TableMap tableMap) throws TorqueException {
        c.getSelectColumns().clear();
        c.getOrderByColumns().clear();
        c.getGroupByColumns().clear();
        UniqueList<String> criteriaSelectModifiers = c.getSelectModifiers();
        boolean distinct = this.isAndSetDistinct(criteriaSelectModifiers);
        c.addSelectColumn(new Avg(new ColumnImpl(columnName), distinct));
        String databaseName = c.getDbName() == null ? Torque.getDefaultDB() : c.getDbName();
        BasePeerImpl<BigDecimal> peer = new BasePeerImpl<BigDecimal>(new BigDecimalMapper(), tableMap, databaseName);
        List<BigDecimal> result = conn == null ? peer.doSelect(c) : peer.doSelect(c, conn);
        return result.get(0);
    }

    private boolean isAndSetDistinct(UniqueList<String> criteriaSelectModifiers) {
        boolean distinct = false;
        if (criteriaSelectModifiers != null && criteriaSelectModifiers.size() > 0 && criteriaSelectModifiers.contains(SqlEnum.DISTINCT.toString())) {
            criteriaSelectModifiers.remove(SqlEnum.DISTINCT.toString());
            distinct = true;
        }
        return distinct;
    }
}

