/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.api.config.view;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Iterator;
import java.util.Set;
import org.apache.deltaspike.core.api.config.view.metadata.SkipMetaDataMerge;
import org.apache.deltaspike.core.api.config.view.metadata.ViewMetaData;
import org.apache.deltaspike.core.spi.config.view.ConfigPreProcessor;
import org.apache.deltaspike.core.spi.config.view.ViewConfigNode;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.jsf.api.config.base.JsfBaseConfig;
import org.apache.deltaspike.jsf.api.literal.FolderLiteral;
import org.apache.deltaspike.jsf.util.NamingConventionUtils;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@ViewMetaData(preProcessor=FolderConfigPreProcessor.class)
public @interface Folder {
    @SkipMetaDataMerge
    public String name() default ".";

    public Class<? extends NameBuilder> folderNameBuilder() default DefaultFolderNameBuilder.class;

    public static class DefaultFolderNameBuilder
    implements NameBuilder {
        private boolean defaultValueReplaced = false;

        @Override
        public String build(Folder folder, ViewConfigNode viewConfigNode) {
            Object name = folder.name();
            if (name == null || ".".equals(name)) {
                name = NamingConventionUtils.toPath(viewConfigNode);
                this.defaultValueReplaced = true;
            }
            if (name != null && ((String)name).startsWith(".")) {
                name = NamingConventionUtils.toPath(viewConfigNode.getParent()) + ((String)name).substring(1);
                this.defaultValueReplaced = true;
            }
            if (name != null && !((String)name).startsWith(".") && !((String)name).startsWith("/")) {
                name = NamingConventionUtils.toPath(viewConfigNode.getParent()) + (String)name;
                this.defaultValueReplaced = true;
            }
            if (name != null && !((String)name).endsWith("/")) {
                name = (String)name + "/";
                this.defaultValueReplaced = true;
            }
            if (name != null && ((String)name).contains("//")) {
                name = ((String)name).replace("//", "/");
                this.defaultValueReplaced = true;
            }
            return name;
        }

        @Override
        public boolean isDefaultValueReplaced() {
            return this.defaultValueReplaced;
        }
    }

    public static interface NameBuilder {
        public String build(Folder var1, ViewConfigNode var2);

        public boolean isDefaultValueReplaced();
    }

    public static class FolderConfigPreProcessor
    implements ConfigPreProcessor<Folder> {
        public Folder beforeAddToConfig(Folder folder, ViewConfigNode viewConfigNode) {
            boolean defaultValueReplaced = false;
            NameBuilder folderNameBuilder = this.getFolderNameBuilder(folder);
            String name = folderNameBuilder.build(folder, viewConfigNode);
            if (folderNameBuilder.isDefaultValueReplaced()) {
                defaultValueReplaced = true;
            }
            if (defaultValueReplaced) {
                FolderLiteral result = new FolderLiteral(name, folder.folderNameBuilder());
                this.updateNodeMetaData(viewConfigNode, result);
                return result;
            }
            return folder;
        }

        private void updateNodeMetaData(ViewConfigNode viewConfigNode, Folder folder) {
            Set metaData = viewConfigNode.getMetaData();
            Iterator metaDataIterator = metaData.iterator();
            while (metaDataIterator.hasNext()) {
                if (!Folder.class.equals(((Annotation)metaDataIterator.next()).annotationType())) continue;
                metaDataIterator.remove();
                break;
            }
            metaData.add(folder);
        }

        private NameBuilder getFolderNameBuilder(Folder folder) {
            String customDefaultFolderNameBuilderClassName;
            NameBuilder folderNameBuilder = DefaultFolderNameBuilder.class.equals(folder.folderNameBuilder()) ? ((customDefaultFolderNameBuilderClassName = JsfBaseConfig.ViewConfigCustomization.CUSTOM_DEFAULT_FOLDER_NAME_BUILDER) != null ? (NameBuilder)ClassUtils.tryToInstantiateClassForName((String)customDefaultFolderNameBuilderClassName) : new DefaultFolderNameBuilder()) : (NameBuilder)ClassUtils.tryToInstantiateClass(folder.folderNameBuilder());
            return folderNameBuilder;
        }
    }
}

