/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jpa.spi.descriptor.xml;

import jakarta.enterprise.inject.Vetoed;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.deltaspike.core.util.StringUtils;
import org.apache.deltaspike.jpa.spi.descriptor.xml.AbstractEntityDescriptor;
import org.apache.deltaspike.jpa.spi.descriptor.xml.EntityDescriptor;
import org.apache.deltaspike.jpa.spi.descriptor.xml.PersistenceUnitDescriptor;
import org.apache.deltaspike.jpa.spi.descriptor.xml.PersistenceUnitDescriptorParser;

@Vetoed
public final class PersistenceUnitDescriptorProvider {
    private static final PersistenceUnitDescriptorProvider INSTANCE = new PersistenceUnitDescriptorProvider();
    private final PersistenceUnitDescriptorParser persistenceUnitDescriptorParser = new PersistenceUnitDescriptorParser();
    private List<PersistenceUnitDescriptor> persistenceUnitDescriptors = Collections.emptyList();

    private PersistenceUnitDescriptorProvider() {
    }

    public static PersistenceUnitDescriptorProvider getInstance() {
        return INSTANCE;
    }

    public void init() {
        try {
            this.persistenceUnitDescriptors = this.persistenceUnitDescriptorParser.readAll();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse persitence.xml's", e);
        }
    }

    public PersistenceUnitDescriptor get(String name) {
        for (PersistenceUnitDescriptor unit : this.persistenceUnitDescriptors) {
            if (!name.equalsIgnoreCase(unit.getName())) continue;
            return unit;
        }
        return null;
    }

    public boolean isEntity(Class<?> entityClass) {
        return this.find(entityClass) != null;
    }

    public String[] primaryKeyFields(Class<?> entityClass) {
        EntityDescriptor entity = this.find(entityClass);
        if (entity != null) {
            if (entity.getId() != null) {
                return entity.getId();
            }
            for (AbstractEntityDescriptor parent = entity.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.getId() == null) continue;
                return parent.getId();
            }
        }
        return null;
    }

    public String versionField(Class<?> entityClass) {
        EntityDescriptor entity = this.find(entityClass);
        if (entity != null) {
            if (!StringUtils.isEmpty((String)entity.getVersion())) {
                return entity.getVersion();
            }
            for (AbstractEntityDescriptor parent = entity.getParent(); parent != null; parent = parent.getParent()) {
                if (StringUtils.isEmpty((String)parent.getVersion())) continue;
                return parent.getVersion();
            }
        }
        return null;
    }

    public Class<?> primaryKeyIdClass(Class<?> entityClass) {
        EntityDescriptor entity = this.find(entityClass);
        if (entity != null) {
            if (entity.getIdClass() != null) {
                return entity.getIdClass();
            }
            for (AbstractEntityDescriptor parent = entity.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.getIdClass() == null) continue;
                return parent.getIdClass();
            }
        }
        return null;
    }

    public String entityName(Class<?> entityClass) {
        EntityDescriptor entity = this.find(entityClass);
        if (entity != null) {
            return entity.getName();
        }
        return null;
    }

    public String entityTableName(Class<?> entityClass) {
        EntityDescriptor entity = this.find(entityClass);
        if (entity != null) {
            return entity.getTableName();
        }
        return null;
    }

    public EntityDescriptor find(Class<?> entityClass) {
        for (PersistenceUnitDescriptor unit : this.persistenceUnitDescriptors) {
            EntityDescriptor entity = this.find(entityClass, unit);
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    protected EntityDescriptor find(Class<?> entityClass, PersistenceUnitDescriptor descriptor) {
        for (EntityDescriptor entity : descriptor.getEntityDescriptors()) {
            if (!entity.getEntityClass().equals(entityClass)) continue;
            return entity;
        }
        return null;
    }
}

