/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class AggregatedClassLoader
extends ClassLoader {
    private final List<ClassLoader> classLoaders;

    public AggregatedClassLoader(List<ClassLoader> classLoaders) {
        this.classLoaders = classLoaders;
    }

    public static AggregatedClassLoader newInstance() {
        return new AggregatedClassLoader(Arrays.asList(AggregatedClassLoader.class.getClassLoader(), Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader()));
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader loader : this.classLoaders) {
            URL url = loader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        final LinkedHashSet<URL> result = new LinkedHashSet<URL>();
        for (ClassLoader loader : this.classLoaders) {
            Enumeration<URL> urls = loader.getResources(name);
            while (urls.hasMoreElements()) {
                result.add(urls.nextElement());
            }
        }
        return new Enumeration<URL>(){
            private final Iterator<URL> iterator;
            {
                this.iterator = result.iterator();
            }

            @Override
            public URL nextElement() {
                return this.iterator.next();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }
        };
    }
}

