/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.auth;

import io.etcd.jetcd.AbstractResponse;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.auth.Permission;
import java.util.List;
import java.util.stream.Collectors;

public class AuthRoleGetResponse
extends AbstractResponse<io.etcd.jetcd.api.AuthRoleGetResponse> {
    private List<Permission> permissions;

    public AuthRoleGetResponse(io.etcd.jetcd.api.AuthRoleGetResponse response) {
        super(response, response.getHeader());
    }

    private static Permission toPermission(io.etcd.jetcd.api.Permission perm) {
        Permission.Type type;
        ByteSequence key = ByteSequence.from(perm.getKey());
        ByteSequence rangeEnd = ByteSequence.from(perm.getRangeEnd());
        switch (perm.getPermType()) {
            case READ: {
                type = Permission.Type.READ;
                break;
            }
            case WRITE: {
                type = Permission.Type.WRITE;
                break;
            }
            case READWRITE: {
                type = Permission.Type.READWRITE;
                break;
            }
            default: {
                type = Permission.Type.UNRECOGNIZED;
            }
        }
        return new Permission(type, key, rangeEnd);
    }

    public synchronized List<Permission> getPermissions() {
        if (this.permissions == null) {
            this.permissions = ((io.etcd.jetcd.api.AuthRoleGetResponse)this.getResponse()).getPermList().stream().map(AuthRoleGetResponse::toPermission).collect(Collectors.toList());
        }
        return this.permissions;
    }
}

