/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGenerateUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CodeGenerateUtils.class);
    private static final CodeGenerator codeGenerator;

    public static long genCode() throws CodeGenerateException {
        return codeGenerator.genCode();
    }

    static {
        try {
            codeGenerator = new CodeGenerator(InetAddress.getLocalHost().getHostName() + "-" + OSUtils.getProcessID());
        }
        catch (UnknownHostException e) {
            throw new CodeGenerateException(e.getMessage());
        }
    }

    public static class CodeGenerateException
    extends RuntimeException {
        public CodeGenerateException(String message) {
            super(message);
        }
    }

    public static class CodeGenerator {
        private static final long START_TIMESTAMP = 1609430400000L;
        private static final long LOW_DIGIT_BIT = 5L;
        private static final long MACHINE_BIT = 5L;
        private static final long MAX_LOW_DIGIT = 31L;
        private static final long HIGH_DIGIT_LEFT = 10L;
        public final long machineHash;
        private long lowDigit = 0L;
        private long recordMillisecond = -1L;
        private static final long SYSTEM_TIMESTAMP = System.currentTimeMillis();
        private static final long SYSTEM_NANOTIME = System.nanoTime();

        public CodeGenerator(String appName) {
            this.machineHash = Math.abs(Objects.hash(appName)) % 32;
        }

        public synchronized long genCode() throws CodeGenerateException {
            long nowtMillisecond = this.systemMillisecond();
            if (nowtMillisecond < this.recordMillisecond) {
                throw new CodeGenerateException("New code exception because time is set back.");
            }
            if (nowtMillisecond == this.recordMillisecond) {
                this.lowDigit = this.lowDigit + 1L & 0x1FL;
                if (this.lowDigit == 0L) {
                    while (nowtMillisecond <= this.recordMillisecond) {
                        nowtMillisecond = this.systemMillisecond();
                    }
                }
            } else {
                this.lowDigit = 0L;
            }
            this.recordMillisecond = nowtMillisecond;
            return nowtMillisecond - 1609430400000L << 10 | this.machineHash << 5 | this.lowDigit;
        }

        private long systemMillisecond() {
            return SYSTEM_TIMESTAMP + (System.nanoTime() - SYSTEM_NANOTIME) / 1000000L;
        }
    }
}

