/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.repository.impl;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskRelation;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowTaskRelationLogMapper;
import org.apache.dolphinscheduler.dao.repository.BaseDao;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionLogDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class TaskDefinitionLogDaoImpl
extends BaseDao<TaskDefinitionLog, TaskDefinitionLogMapper>
implements TaskDefinitionLogDao {
    @Autowired
    private WorkflowTaskRelationLogMapper workflowTaskRelationLogMapper;

    public TaskDefinitionLogDaoImpl(@NonNull TaskDefinitionLogMapper taskDefinitionLogMapper) {
        super(taskDefinitionLogMapper);
        if (taskDefinitionLogMapper == null) {
            throw new NullPointerException("taskDefinitionLogMapper is marked non-null but is null");
        }
    }

    @Override
    public List<TaskDefinitionLog> queryByWorkflowDefinitionCodeAndVersion(Long workflowDefinitionCode, Integer workflowDefinitionVersion) {
        List<WorkflowTaskRelation> workflowTaskRelationLogs = this.workflowTaskRelationLogMapper.queryByWorkflowCodeAndVersion(workflowDefinitionCode, workflowDefinitionVersion).stream().map(p -> p).collect(Collectors.toList());
        return this.queryTaskDefineLogList(workflowTaskRelationLogs);
    }

    @Override
    public List<TaskDefinitionLog> queryTaskDefineLogList(List<WorkflowTaskRelation> workflowTaskRelations) {
        if (CollectionUtils.isEmpty(workflowTaskRelations)) {
            return Collections.emptyList();
        }
        Set<TaskDefinition> taskDefinitionSet = workflowTaskRelations.stream().filter(p -> p.getPostTaskCode() > 0L).map(p -> new TaskDefinition(p.getPostTaskCode(), p.getPostTaskVersion())).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(taskDefinitionSet)) {
            return Collections.emptyList();
        }
        return ((TaskDefinitionLogMapper)this.mybatisMapper).queryByTaskDefinitions(taskDefinitionSet);
    }

    @Override
    public void deleteByTaskDefinitionCodes(Set<Long> taskDefinitionCodes) {
        if (CollectionUtils.isEmpty(taskDefinitionCodes)) {
            return;
        }
        ((TaskDefinitionLogMapper)this.mybatisMapper).deleteByTaskDefinitionCodes(taskDefinitionCodes);
    }
}

