/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.TaskExecuteType;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;

@TableName(value="t_ds_task_definition")
public class TaskDefinition {
    @TableId(value="id", type=IdType.AUTO)
    private Integer id;
    private long code;
    private String name;
    private int version;
    private String description;
    private long projectCode;
    private int userId;
    private String taskType;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String taskParams;
    @TableField(exist=false)
    private List<Property> taskParamList;
    @TableField(exist=false)
    private Map<String, String> taskParamMap;
    private Flag flag;
    private Priority taskPriority;
    @TableField(exist=false)
    private String userName;
    @TableField(exist=false)
    private String projectName;
    private String workerGroup;
    private long environmentCode;
    private int failRetryTimes;
    private int failRetryInterval;
    private TimeoutFlag timeoutFlag;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private TaskTimeoutStrategy timeoutNotifyStrategy;
    private int timeout;
    private int delayTime;
    @Deprecated
    private String resourceIds;
    private Date createTime;
    private Date updateTime;
    @TableField(exist=false)
    private String modifyBy;
    private int taskGroupId;
    private int taskGroupPriority;
    private Integer cpuQuota;
    private Integer memoryMax;
    private TaskExecuteType taskExecuteType;

    public TaskDefinition(long code, int version) {
        this.code = code;
        this.version = version;
    }

    public List<Property> getTaskParamList() {
        JsonNode localParams = JSONUtils.parseObject((String)this.taskParams).findValue("localParams");
        if (localParams != null) {
            this.taskParamList = JSONUtils.toList((String)localParams.toString(), Property.class);
        }
        return this.taskParamList;
    }

    public Map<String, String> getTaskParamMap() {
        List propList;
        JsonNode localParams;
        if (this.taskParamMap == null && !Strings.isNullOrEmpty((String)this.taskParams) && (localParams = JSONUtils.parseObject((String)this.taskParams).findValue("localParams")) != null && !localParams.isNull() && CollectionUtils.isNotEmpty((Collection)(propList = JSONUtils.toList((String)localParams.toString(), Property.class)))) {
            this.taskParamMap = new HashMap<String, String>();
            for (Property property : propList) {
                this.taskParamMap.put(property.getProp(), property.getValue());
            }
        }
        return this.taskParamMap;
    }

    public Integer getCpuQuota() {
        return this.cpuQuota == null ? -1 : this.cpuQuota;
    }

    public Integer getMemoryMax() {
        return this.memoryMax == null ? -1 : this.memoryMax;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        TaskDefinition that = (TaskDefinition)o;
        return this.failRetryTimes == that.failRetryTimes && this.failRetryInterval == that.failRetryInterval && this.timeout == that.timeout && this.delayTime == that.delayTime && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.taskType, that.taskType) && Objects.equals(this.taskParams, that.taskParams) && this.flag == that.flag && this.taskPriority == that.taskPriority && Objects.equals(this.workerGroup, that.workerGroup) && this.timeoutFlag == that.timeoutFlag && this.timeoutNotifyStrategy == that.timeoutNotifyStrategy && (Objects.equals(this.resourceIds, that.resourceIds) || "".equals(this.resourceIds) && that.resourceIds == null || "".equals(that.resourceIds) && this.resourceIds == null) && this.environmentCode == that.environmentCode && this.taskGroupId == that.taskGroupId && this.taskGroupPriority == that.taskGroupPriority && Objects.equals(this.cpuQuota, that.cpuQuota) && Objects.equals(this.memoryMax, that.memoryMax) && Objects.equals(this.taskExecuteType, that.taskExecuteType);
    }

    @Generated
    public static TaskDefinitionBuilder builder() {
        return new TaskDefinitionBuilder();
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public long getCode() {
        return this.code;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getVersion() {
        return this.version;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public long getProjectCode() {
        return this.projectCode;
    }

    @Generated
    public int getUserId() {
        return this.userId;
    }

    @Generated
    public String getTaskType() {
        return this.taskType;
    }

    @Generated
    public String getTaskParams() {
        return this.taskParams;
    }

    @Generated
    public Flag getFlag() {
        return this.flag;
    }

    @Generated
    public Priority getTaskPriority() {
        return this.taskPriority;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public String getWorkerGroup() {
        return this.workerGroup;
    }

    @Generated
    public long getEnvironmentCode() {
        return this.environmentCode;
    }

    @Generated
    public int getFailRetryTimes() {
        return this.failRetryTimes;
    }

    @Generated
    public int getFailRetryInterval() {
        return this.failRetryInterval;
    }

    @Generated
    public TimeoutFlag getTimeoutFlag() {
        return this.timeoutFlag;
    }

    @Generated
    public TaskTimeoutStrategy getTimeoutNotifyStrategy() {
        return this.timeoutNotifyStrategy;
    }

    @Generated
    public int getTimeout() {
        return this.timeout;
    }

    @Generated
    public int getDelayTime() {
        return this.delayTime;
    }

    @Deprecated
    @Generated
    public String getResourceIds() {
        return this.resourceIds;
    }

    @Generated
    public Date getCreateTime() {
        return this.createTime;
    }

    @Generated
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public String getModifyBy() {
        return this.modifyBy;
    }

    @Generated
    public int getTaskGroupId() {
        return this.taskGroupId;
    }

    @Generated
    public int getTaskGroupPriority() {
        return this.taskGroupPriority;
    }

    @Generated
    public TaskExecuteType getTaskExecuteType() {
        return this.taskExecuteType;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public void setCode(long code) {
        this.code = code;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setVersion(int version) {
        this.version = version;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setProjectCode(long projectCode) {
        this.projectCode = projectCode;
    }

    @Generated
    public void setUserId(int userId) {
        this.userId = userId;
    }

    @Generated
    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @Generated
    public void setTaskParams(String taskParams) {
        this.taskParams = taskParams;
    }

    @Generated
    public void setTaskParamList(List<Property> taskParamList) {
        this.taskParamList = taskParamList;
    }

    @Generated
    public void setTaskParamMap(Map<String, String> taskParamMap) {
        this.taskParamMap = taskParamMap;
    }

    @Generated
    public void setFlag(Flag flag) {
        this.flag = flag;
    }

    @Generated
    public void setTaskPriority(Priority taskPriority) {
        this.taskPriority = taskPriority;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Generated
    public void setWorkerGroup(String workerGroup) {
        this.workerGroup = workerGroup;
    }

    @Generated
    public void setEnvironmentCode(long environmentCode) {
        this.environmentCode = environmentCode;
    }

    @Generated
    public void setFailRetryTimes(int failRetryTimes) {
        this.failRetryTimes = failRetryTimes;
    }

    @Generated
    public void setFailRetryInterval(int failRetryInterval) {
        this.failRetryInterval = failRetryInterval;
    }

    @Generated
    public void setTimeoutFlag(TimeoutFlag timeoutFlag) {
        this.timeoutFlag = timeoutFlag;
    }

    @Generated
    public void setTimeoutNotifyStrategy(TaskTimeoutStrategy timeoutNotifyStrategy) {
        this.timeoutNotifyStrategy = timeoutNotifyStrategy;
    }

    @Generated
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
    }

    @Deprecated
    @Generated
    public void setResourceIds(String resourceIds) {
        this.resourceIds = resourceIds;
    }

    @Generated
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setModifyBy(String modifyBy) {
        this.modifyBy = modifyBy;
    }

    @Generated
    public void setTaskGroupId(int taskGroupId) {
        this.taskGroupId = taskGroupId;
    }

    @Generated
    public void setTaskGroupPriority(int taskGroupPriority) {
        this.taskGroupPriority = taskGroupPriority;
    }

    @Generated
    public void setCpuQuota(Integer cpuQuota) {
        this.cpuQuota = cpuQuota;
    }

    @Generated
    public void setMemoryMax(Integer memoryMax) {
        this.memoryMax = memoryMax;
    }

    @Generated
    public void setTaskExecuteType(TaskExecuteType taskExecuteType) {
        this.taskExecuteType = taskExecuteType;
    }

    @Generated
    public String toString() {
        return "TaskDefinition(id=" + this.getId() + ", code=" + this.getCode() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", projectCode=" + this.getProjectCode() + ", userId=" + this.getUserId() + ", taskType=" + this.getTaskType() + ", taskParams=" + this.getTaskParams() + ", taskParamList=" + this.getTaskParamList() + ", taskParamMap=" + this.getTaskParamMap() + ", flag=" + this.getFlag() + ", taskPriority=" + this.getTaskPriority() + ", userName=" + this.getUserName() + ", projectName=" + this.getProjectName() + ", workerGroup=" + this.getWorkerGroup() + ", environmentCode=" + this.getEnvironmentCode() + ", failRetryTimes=" + this.getFailRetryTimes() + ", failRetryInterval=" + this.getFailRetryInterval() + ", timeoutFlag=" + this.getTimeoutFlag() + ", timeoutNotifyStrategy=" + this.getTimeoutNotifyStrategy() + ", timeout=" + this.getTimeout() + ", delayTime=" + this.getDelayTime() + ", resourceIds=" + this.getResourceIds() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", modifyBy=" + this.getModifyBy() + ", taskGroupId=" + this.getTaskGroupId() + ", taskGroupPriority=" + this.getTaskGroupPriority() + ", cpuQuota=" + this.getCpuQuota() + ", memoryMax=" + this.getMemoryMax() + ", taskExecuteType=" + this.getTaskExecuteType() + ")";
    }

    @Generated
    public TaskDefinition() {
    }

    @Generated
    public TaskDefinition(Integer id, long code, String name, int version, String description, long projectCode, int userId, String taskType, String taskParams, List<Property> taskParamList, Map<String, String> taskParamMap, Flag flag, Priority taskPriority, String userName, String projectName, String workerGroup, long environmentCode, int failRetryTimes, int failRetryInterval, TimeoutFlag timeoutFlag, TaskTimeoutStrategy timeoutNotifyStrategy, int timeout, int delayTime, String resourceIds, Date createTime, Date updateTime, String modifyBy, int taskGroupId, int taskGroupPriority, Integer cpuQuota, Integer memoryMax, TaskExecuteType taskExecuteType) {
        this.id = id;
        this.code = code;
        this.name = name;
        this.version = version;
        this.description = description;
        this.projectCode = projectCode;
        this.userId = userId;
        this.taskType = taskType;
        this.taskParams = taskParams;
        this.taskParamList = taskParamList;
        this.taskParamMap = taskParamMap;
        this.flag = flag;
        this.taskPriority = taskPriority;
        this.userName = userName;
        this.projectName = projectName;
        this.workerGroup = workerGroup;
        this.environmentCode = environmentCode;
        this.failRetryTimes = failRetryTimes;
        this.failRetryInterval = failRetryInterval;
        this.timeoutFlag = timeoutFlag;
        this.timeoutNotifyStrategy = timeoutNotifyStrategy;
        this.timeout = timeout;
        this.delayTime = delayTime;
        this.resourceIds = resourceIds;
        this.createTime = createTime;
        this.updateTime = updateTime;
        this.modifyBy = modifyBy;
        this.taskGroupId = taskGroupId;
        this.taskGroupPriority = taskGroupPriority;
        this.cpuQuota = cpuQuota;
        this.memoryMax = memoryMax;
        this.taskExecuteType = taskExecuteType;
    }

    @Generated
    public static class TaskDefinitionBuilder {
        @Generated
        private Integer id;
        @Generated
        private long code;
        @Generated
        private String name;
        @Generated
        private int version;
        @Generated
        private String description;
        @Generated
        private long projectCode;
        @Generated
        private int userId;
        @Generated
        private String taskType;
        @Generated
        private String taskParams;
        @Generated
        private List<Property> taskParamList;
        @Generated
        private Map<String, String> taskParamMap;
        @Generated
        private Flag flag;
        @Generated
        private Priority taskPriority;
        @Generated
        private String userName;
        @Generated
        private String projectName;
        @Generated
        private String workerGroup;
        @Generated
        private long environmentCode;
        @Generated
        private int failRetryTimes;
        @Generated
        private int failRetryInterval;
        @Generated
        private TimeoutFlag timeoutFlag;
        @Generated
        private TaskTimeoutStrategy timeoutNotifyStrategy;
        @Generated
        private int timeout;
        @Generated
        private int delayTime;
        @Generated
        private String resourceIds;
        @Generated
        private Date createTime;
        @Generated
        private Date updateTime;
        @Generated
        private String modifyBy;
        @Generated
        private int taskGroupId;
        @Generated
        private int taskGroupPriority;
        @Generated
        private Integer cpuQuota;
        @Generated
        private Integer memoryMax;
        @Generated
        private TaskExecuteType taskExecuteType;

        @Generated
        TaskDefinitionBuilder() {
        }

        @Generated
        public TaskDefinitionBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder code(long code) {
            this.code = code;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder version(int version) {
            this.version = version;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder projectCode(long projectCode) {
            this.projectCode = projectCode;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder userId(int userId) {
            this.userId = userId;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
        @Generated
        public TaskDefinitionBuilder taskParams(String taskParams) {
            this.taskParams = taskParams;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder taskParamList(List<Property> taskParamList) {
            this.taskParamList = taskParamList;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder taskParamMap(Map<String, String> taskParamMap) {
            this.taskParamMap = taskParamMap;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder flag(Flag flag) {
            this.flag = flag;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder taskPriority(Priority taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder workerGroup(String workerGroup) {
            this.workerGroup = workerGroup;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder environmentCode(long environmentCode) {
            this.environmentCode = environmentCode;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder failRetryTimes(int failRetryTimes) {
            this.failRetryTimes = failRetryTimes;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder failRetryInterval(int failRetryInterval) {
            this.failRetryInterval = failRetryInterval;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder timeoutFlag(TimeoutFlag timeoutFlag) {
            this.timeoutFlag = timeoutFlag;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder timeoutNotifyStrategy(TaskTimeoutStrategy timeoutNotifyStrategy) {
            this.timeoutNotifyStrategy = timeoutNotifyStrategy;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder delayTime(int delayTime) {
            this.delayTime = delayTime;
            return this;
        }

        @Deprecated
        @Generated
        public TaskDefinitionBuilder resourceIds(String resourceIds) {
            this.resourceIds = resourceIds;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder updateTime(Date updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder modifyBy(String modifyBy) {
            this.modifyBy = modifyBy;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder taskGroupId(int taskGroupId) {
            this.taskGroupId = taskGroupId;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder taskGroupPriority(int taskGroupPriority) {
            this.taskGroupPriority = taskGroupPriority;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder cpuQuota(Integer cpuQuota) {
            this.cpuQuota = cpuQuota;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder memoryMax(Integer memoryMax) {
            this.memoryMax = memoryMax;
            return this;
        }

        @Generated
        public TaskDefinitionBuilder taskExecuteType(TaskExecuteType taskExecuteType) {
            this.taskExecuteType = taskExecuteType;
            return this;
        }

        @Generated
        public TaskDefinition build() {
            return new TaskDefinition(this.id, this.code, this.name, this.version, this.description, this.projectCode, this.userId, this.taskType, this.taskParams, this.taskParamList, this.taskParamMap, this.flag, this.taskPriority, this.userName, this.projectName, this.workerGroup, this.environmentCode, this.failRetryTimes, this.failRetryInterval, this.timeoutFlag, this.timeoutNotifyStrategy, this.timeout, this.delayTime, this.resourceIds, this.createTime, this.updateTime, this.modifyBy, this.taskGroupId, this.taskGroupPriority, this.cpuQuota, this.memoryMax, this.taskExecuteType);
        }

        @Generated
        public String toString() {
            return "TaskDefinition.TaskDefinitionBuilder(id=" + this.id + ", code=" + this.code + ", name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", projectCode=" + this.projectCode + ", userId=" + this.userId + ", taskType=" + this.taskType + ", taskParams=" + this.taskParams + ", taskParamList=" + this.taskParamList + ", taskParamMap=" + this.taskParamMap + ", flag=" + this.flag + ", taskPriority=" + this.taskPriority + ", userName=" + this.userName + ", projectName=" + this.projectName + ", workerGroup=" + this.workerGroup + ", environmentCode=" + this.environmentCode + ", failRetryTimes=" + this.failRetryTimes + ", failRetryInterval=" + this.failRetryInterval + ", timeoutFlag=" + this.timeoutFlag + ", timeoutNotifyStrategy=" + this.timeoutNotifyStrategy + ", timeout=" + this.timeout + ", delayTime=" + this.delayTime + ", resourceIds=" + this.resourceIds + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", modifyBy=" + this.modifyBy + ", taskGroupId=" + this.taskGroupId + ", taskGroupPriority=" + this.taskGroupPriority + ", cpuQuota=" + this.cpuQuota + ", memoryMax=" + this.memoryMax + ", taskExecuteType=" + this.taskExecuteType + ")";
        }
    }
}

