/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.service;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.SimpleProgressManager;
import com.obs.services.internal.handler.XmlResponsesSaxParser;
import com.obs.services.internal.io.HttpMethodReleaseInputStream;
import com.obs.services.internal.io.ProgressInputStream;
import com.obs.services.internal.service.AbstractRequestConvertor;
import com.obs.services.internal.service.ObsBucketAdvanceService;
import com.obs.services.internal.trans.NewTransResult;
import com.obs.services.internal.utils.RestUtils;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.CopyObjectRequest;
import com.obs.services.model.CopyObjectResult;
import com.obs.services.model.DeleteObjectRequest;
import com.obs.services.model.DeleteObjectResult;
import com.obs.services.model.DeleteObjectsRequest;
import com.obs.services.model.DeleteObjectsResult;
import com.obs.services.model.GetObjectAclRequest;
import com.obs.services.model.GetObjectMetadataRequest;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.SetObjectAclRequest;
import com.obs.services.model.SetObjectMetadataRequest;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.fs.DropFileResult;
import com.obs.services.model.fs.ObsFSAttribute;
import com.obs.services.model.fs.ObsFSFile;
import com.obs.services.model.fs.ReadFileResult;
import com.obs.services.model.select.SelectObjectRequest;
import com.obs.services.model.select.SelectObjectResult;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import shade.okhttp3.Request;
import shade.okhttp3.RequestBody;
import shade.okhttp3.Response;
import shade.okhttp3.ResponseBody;

public abstract class ObsObjectBaseService
extends ObsBucketAdvanceService {
    private static final ILogger log = LoggerBuilder.getLogger(ObsObjectBaseService.class);

    protected boolean doesObjectExistImpl(GetObjectMetadataRequest request) throws ServiceException {
        boolean doesObjectExist;
        block4: {
            HashMap<String, String> headers = new HashMap<String, String>();
            this.transSseCHeaders(request.getSseCHeader(), headers, this.getIHeaders(request.getBucketName()));
            this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
            HashMap<String, String> params = new HashMap<String, String>();
            if (request.getVersionId() != null) {
                params.put("versionId", request.getVersionId());
            }
            doesObjectExist = false;
            try {
                Response response = this.performRestHead(request.getBucketName(), request.getObjectKey(), params, headers, new HashMap<String, String>(), request.isEncodeHeaders());
                if (200 == response.code()) {
                    doesObjectExist = true;
                }
            }
            catch (ServiceException ex) {
                if (404 == ex.getResponseCode()) break block4;
                throw ex;
            }
        }
        return doesObjectExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObsFSFile putObjectImpl(PutObjectRequest request) throws ServiceException {
        ObsFSFile ret;
        block8: {
            Response response;
            boolean isExtraAclPutRequired;
            AbstractRequestConvertor.TransResult result = null;
            AccessControlList acl = request.getAcl();
            try {
                result = this.transPutObjectRequest(request);
                isExtraAclPutRequired = !this.prepareRESTHeaderAcl(request.getBucketName(), result.getHeaders(), acl);
                NewTransResult newTransResult = this.transObjectRequestWithResult(result, request);
                response = this.performRequest(newTransResult);
            }
            finally {
                if (result != null && result.getBody() != null && request.isAutoClose() && result.getBody() instanceof Closeable) {
                    ServiceUtils.closeStream((Closeable)((Object)result.getBody()));
                }
            }
            ret = new ObsFSFile(request.getBucketName(), request.getObjectKey(), response.header("ETag"), response.header(this.getIHeaders(request.getBucketName()).versionIdHeader()), StorageClassEnum.getValueFromCode(response.header(this.getIHeaders(request.getBucketName()).storageClassHeader())), this.getObjectUrl(request.getBucketName(), request.getObjectKey(), request.getIsIgnorePort()));
            this.setHeadersAndStatus(ret, response);
            if (isExtraAclPutRequired && acl != null) {
                try {
                    this.putAclImpl(request.getBucketName(), request.getObjectKey(), acl, null, request.isRequesterPays());
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return ret;
    }

    protected ObsObject getObjectImpl(GetObjectRequest request) throws ServiceException {
        return (ObsObject)this.getObjectImpl((GetObjectMetadataRequest)request);
    }

    protected Object getObjectImpl(GetObjectMetadataRequest request) throws ServiceException {
        int readBufferSize;
        Response response;
        GetObjectRequest getRequest = null;
        if (!(request instanceof GetObjectRequest)) {
            HashMap<String, String> headers = new HashMap<String, String>();
            this.transSseCHeaders(request.getSseCHeader(), headers, this.getIHeaders(request.getBucketName()));
            this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
            HashMap<String, String> params = new HashMap<String, String>();
            if (request.getVersionId() != null) {
                params.put("versionId", request.getVersionId());
            }
            response = this.performRestHead(request.getBucketName(), request.getObjectKey(), params, headers, request.getUserHeaders(), request.isEncodeHeaders());
        } else {
            getRequest = (GetObjectRequest)request;
            AbstractRequestConvertor.TransResult result = this.transGetObjectRequest(getRequest);
            if (getRequest.getRequestParameters() != null) {
                result.getParams().putAll(getRequest.getRequestParameters());
            }
            response = this.performRestGet(request.getBucketName(), request.getObjectKey(), result.getParams(), result.getHeaders(), request.getUserHeaders(), false, request.isEncodeHeaders());
        }
        ObsFSAttribute objMetadata = this.getObsFSAttributeFromResponse(request.getBucketName(), response, request.isEncodeHeaders());
        if (!(request instanceof GetObjectRequest)) {
            response.close();
            return objMetadata;
        }
        ReadFileResult obsObject = new ReadFileResult();
        obsObject.setObjectKey(request.getObjectKey());
        obsObject.setBucketName(request.getBucketName());
        obsObject.setMetadata(objMetadata);
        InputStream input = response.body().byteStream();
        if (getRequest.getProgressListener() != null) {
            SimpleProgressManager progressManager = new SimpleProgressManager(objMetadata.getContentLength(), 0L, getRequest.getProgressListener(), getRequest.getProgressInterval() > 0L ? getRequest.getProgressInterval() : 102400L);
            input = new ProgressInputStream(input, progressManager);
        }
        if ((readBufferSize = this.obsProperties.getIntProperty("httpclient.read-buffer-size", 8192)) > 0) {
            input = new BufferedInputStream(input, readBufferSize);
        }
        obsObject.setObjectContent(input);
        return obsObject;
    }

    protected SelectObjectResult selectObjectContentImpl(SelectObjectRequest selectRequest) throws ServiceException {
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Content-Type", "application/xml");
        String bucket = selectRequest.getBucketName();
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("select", null);
        requestParams.put("select-type", "2");
        String xml = selectRequest.convertToXml();
        if (log.isDebugEnabled()) {
            log.debug(String.format("selectObjectContentImpl: bucket: %s; object: %s; request XML: %n%s%n", bucket, selectRequest.getKey(), xml));
        }
        NewTransResult transResult = new NewTransResult();
        transResult.setHttpMethod(HttpMethodEnum.POST);
        transResult.setBucketName(bucket);
        transResult.setObjectKey(selectRequest.getKey());
        transResult.setParams(requestParams);
        transResult.setBody(this.createRequestBody("application/xml", xml));
        Request.Builder builder = this.setupConnection(transResult, false, false);
        this.renameMetadataKeys(bucket, builder, httpHeaders);
        Response response = this.performRequest(builder.build(), requestParams, bucket, true, false);
        ResponseBody responseBody = response.body();
        return new SelectObjectResult(responseBody.byteStream());
    }

    protected DeleteObjectsResult deleteObjectsImpl(DeleteObjectsRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.DELETE.getOriginalStringCode(), "");
        String xml = this.getIConvertor(request.getBucketName()).transKeyAndVersion(request.getKeyAndVersions(), request.isQuiet(), request.getEncodingType());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Length", String.valueOf(xml.length()));
        headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
        headers.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        NewTransResult transResult = this.transRequest(request);
        transResult.setParams(requestParams);
        transResult.setHeaders(headers);
        transResult.setBody(this.createRequestBody("application/xml", xml));
        Response response = this.performRequest(transResult, true, false, false, false);
        this.verifyResponseContentType(response);
        DeleteObjectsResult ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.DeleteObjectsHandler.class, true).getMultipleDeleteResult();
        this.setHeadersAndStatus(ret, response);
        return ret;
    }

    protected DeleteObjectResult deleteObjectImpl(DeleteObjectRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        if (request.getVersionId() != null) {
            requestParameters.put("versionId", request.getVersionId());
        }
        Response response = this.performRestDelete(request.getBucketName(), request.getObjectKey(), requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        DropFileResult result = new DropFileResult(Boolean.valueOf(response.header(this.getIHeaders(request.getBucketName()).deleteMarkerHeader())), request.getObjectKey(), response.header(this.getIHeaders(request.getBucketName()).versionIdHeader()));
        this.setHeadersAndStatus(result, response);
        return result;
    }

    protected CopyObjectResult copyObjectImpl(CopyObjectRequest request) throws ServiceException {
        CopyObjectResult copyRet;
        block4: {
            AbstractRequestConvertor.TransResult result = this.transCopyObjectRequest(request);
            AccessControlList acl = request.getAcl();
            boolean isExtraAclPutRequired = !this.prepareRESTHeaderAcl(request.getBucketName(), result.getHeaders(), acl);
            NewTransResult newTransResult = this.transObjectRequestWithResult(result, request);
            Response response = this.performRequest(newTransResult, true, false, false, false);
            this.verifyResponseContentType(response);
            XmlResponsesSaxParser.CopyObjectResultHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.CopyObjectResultHandler.class, false);
            copyRet = new CopyObjectResult(handler.getETag(), handler.getLastModified(), response.header(this.getIHeaders(request.getBucketName()).versionIdHeader()), response.header(this.getIHeaders(request.getBucketName()).copySourceVersionIdHeader()), StorageClassEnum.getValueFromCode(response.header(this.getIHeaders(request.getBucketName()).storageClassHeader())));
            this.setHeadersAndStatus(copyRet, response);
            if (isExtraAclPutRequired && acl != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Creating object with a non-canned ACL using REST, so an extra ACL Put is required");
                }
                try {
                    this.putAclImpl(request.getDestinationBucketName(), request.getDestinationObjectKey(), acl, null, request.isRequesterPays());
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return copyRet;
    }

    protected ObjectMetadata setObjectMetadataImpl(SetObjectMetadataRequest request) {
        AbstractRequestConvertor.TransResult result = this.transSetObjectMetadataRequest(request);
        NewTransResult newTransResult = this.transObjectRequestWithResult(result, request);
        Response response = this.performRequest(newTransResult);
        return this.getObsFSAttributeFromResponse(request.getBucketName(), response, request.isEncodeHeaders());
    }

    protected ObsFSAttribute getObjectMetadataImpl(GetObjectMetadataRequest request) throws ServiceException {
        return (ObsFSAttribute)this.getObjectImpl(request);
    }

    protected HeaderResponse setObjectAclImpl(SetObjectAclRequest request) throws ServiceException {
        boolean isExtraAclPutRequired;
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.ACL.getOriginalStringCode(), "");
        if (request.getVersionId() != null) {
            requestParams.put("versionId", request.getVersionId());
        }
        RequestBody entity = null;
        if (ServiceUtils.isValid(request.getCannedACL())) {
            request.setAcl(this.getIConvertor(request.getBucketName()).transCannedAcl(request.getCannedACL().trim()));
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        boolean bl = isExtraAclPutRequired = !this.prepareRESTHeaderAclObject(request.getBucketName(), headers, request.getAcl());
        if (isExtraAclPutRequired) {
            String xml = request.getAcl() == null ? "" : this.getIConvertor(request.getBucketName()).transAccessControlList(request.getAcl(), false);
            headers.put("Content-Length", String.valueOf(xml.length()));
            headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
            entity = this.createRequestBody("application/xml", xml);
        }
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        NewTransResult result = this.transObjectRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        result.setBody(entity);
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected AccessControlList getObjectAclImpl(GetObjectAclRequest getObjectAclRequest) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ACL.getOriginalStringCode(), "");
        if (ServiceUtils.isValid(getObjectAclRequest.getVersionId())) {
            requestParameters.put("versionId", getObjectAclRequest.getVersionId().trim());
        }
        Response httpResponse = this.performRestGet(getObjectAclRequest.getBucketName(), getObjectAclRequest.getObjectKey(), requestParameters, this.transRequestPaymentHeaders(getObjectAclRequest, null, this.getIHeaders(getObjectAclRequest.getBucketName())), getObjectAclRequest.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        AccessControlList ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.AccessControlListHandler.class, false).getAccessControlList();
        this.setHeadersAndStatus(ret, httpResponse);
        return ret;
    }

    protected String getObjectUrl(String bucketName, String objectKey, boolean isIgnorePort) {
        boolean pathStyle = this.isPathStyle();
        boolean https = this.getHttpsOnly();
        boolean isCname = this.isCname();
        String port = "";
        if (!isIgnorePort) {
            port = ":" + (https ? this.getHttpsPort() : this.getHttpPort());
        }
        return (https ? "https://" : "http://") + (pathStyle || isCname ? "" : bucketName + ".") + this.getEndpoint() + port + "/" + (pathStyle ? bucketName + "/" : "") + RestUtils.uriEncode(objectKey, false);
    }

    private ObsFSAttribute getObsFSAttributeFromResponse(String bucketName, Response response, boolean needDecode) {
        ObsFSAttribute objMetadata;
        block15: {
            String fsMode;
            block14: {
                Date lastModifiedDate;
                block13: {
                    lastModifiedDate = null;
                    String lastModified = response.header("Last-Modified");
                    if (lastModified != null) {
                        try {
                            lastModifiedDate = ServiceUtils.parseRfc822Date(lastModified);
                        }
                        catch (ParseException e) {
                            if (!log.isWarnEnabled()) break block13;
                            log.warn("Response last-modified is not well-format", e);
                        }
                    }
                }
                objMetadata = new ObsFSAttribute();
                objMetadata.setLastModified(lastModifiedDate);
                objMetadata.setContentEncoding(response.header("Content-Encoding"));
                objMetadata.setContentType(response.header("Content-Type"));
                objMetadata.setContentDisposition(response.header("Content-Disposition"));
                objMetadata.setContentLanguage(response.header("Content-Language"));
                objMetadata.setCacheControl(response.header("Cache-Control"));
                objMetadata.setExpires(response.header("Expires"));
                objMetadata.setCrc64(response.header("hash-crc64ecma"));
                String contentLength = response.header("Content-Length");
                if (contentLength != null) {
                    try {
                        objMetadata.setContentLength(Long.parseLong(contentLength));
                    }
                    catch (NumberFormatException e) {
                        if (!log.isWarnEnabled()) break block14;
                        log.warn("Response content-length is not well-format", e);
                    }
                }
            }
            if ((fsMode = response.header(this.getIHeaders(bucketName).fsModeHeader())) != null) {
                objMetadata.setMode(Integer.parseInt(fsMode));
            }
            objMetadata.setWebSiteRedirectLocation(response.header(this.getIHeaders(bucketName).websiteRedirectLocationHeader()));
            objMetadata.setObjectStorageClass(StorageClassEnum.getValueFromCode(response.header(this.getIHeaders(bucketName).storageClassHeader())));
            String etag = response.header("ETag");
            objMetadata.setEtag(etag);
            if (etag != null && !etag.contains("-")) {
                String md5 = etag;
                if (md5.startsWith("\"")) {
                    md5 = md5.substring(1);
                }
                if (md5.endsWith("\"")) {
                    md5 = md5.substring(0, md5.length() - 1);
                }
                try {
                    objMetadata.setContentMd5(ServiceUtils.toBase64(ServiceUtils.fromHex(md5)));
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block15;
                    log.debug(e.getMessage(), e);
                }
            }
        }
        objMetadata.setAppendable("Appendable".equals(response.header(this.getIHeaders(bucketName).objectTypeHeader())));
        String nextPosition = response.header(this.getIHeaders(bucketName).nextPositionHeader(), "-1");
        objMetadata.setNextPosition(Long.parseLong(nextPosition));
        if (objMetadata.getNextPosition() == -1L) {
            objMetadata.setNextPosition(Long.parseLong(response.header("Content-Length", "-1")));
        }
        this.setHeadersAndStatus(objMetadata, response, needDecode);
        objMetadata.setUserMetadata(ServiceUtils.cleanUserMetadata(objMetadata.getOriginalHeaders(), needDecode));
        return objMetadata;
    }
}

