/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.containerservice.fluent.models.OpenShiftManagedClusterProperties;
import com.azure.resourcemanager.containerservice.models.NetworkProfile;
import com.azure.resourcemanager.containerservice.models.OpenShiftManagedClusterAgentPoolProfile;
import com.azure.resourcemanager.containerservice.models.OpenShiftManagedClusterAuthProfile;
import com.azure.resourcemanager.containerservice.models.OpenShiftManagedClusterMasterPoolProfile;
import com.azure.resourcemanager.containerservice.models.OpenShiftRouterProfile;
import com.azure.resourcemanager.containerservice.models.PurchasePlan;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class OpenShiftManagedClusterInner
extends Resource {
    @JsonProperty(value="plan")
    private PurchasePlan plan;
    @JsonProperty(value="properties")
    private OpenShiftManagedClusterProperties innerProperties;

    public PurchasePlan plan() {
        return this.plan;
    }

    public OpenShiftManagedClusterInner withPlan(PurchasePlan plan) {
        this.plan = plan;
        return this;
    }

    private OpenShiftManagedClusterProperties innerProperties() {
        return this.innerProperties;
    }

    public OpenShiftManagedClusterInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public OpenShiftManagedClusterInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String openShiftVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().openShiftVersion();
    }

    public OpenShiftManagedClusterInner withOpenShiftVersion(String openShiftVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OpenShiftManagedClusterProperties();
        }
        this.innerProperties().withOpenShiftVersion(openShiftVersion);
        return this;
    }

    public String clusterVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterVersion();
    }

    public String publicHostname() {
        return this.innerProperties() == null ? null : this.innerProperties().publicHostname();
    }

    public String fqdn() {
        return this.innerProperties() == null ? null : this.innerProperties().fqdn();
    }

    public NetworkProfile networkProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().networkProfile();
    }

    public OpenShiftManagedClusterInner withNetworkProfile(NetworkProfile networkProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OpenShiftManagedClusterProperties();
        }
        this.innerProperties().withNetworkProfile(networkProfile);
        return this;
    }

    public List<OpenShiftRouterProfile> routerProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().routerProfiles();
    }

    public OpenShiftManagedClusterInner withRouterProfiles(List<OpenShiftRouterProfile> routerProfiles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OpenShiftManagedClusterProperties();
        }
        this.innerProperties().withRouterProfiles(routerProfiles);
        return this;
    }

    public OpenShiftManagedClusterMasterPoolProfile masterPoolProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().masterPoolProfile();
    }

    public OpenShiftManagedClusterInner withMasterPoolProfile(OpenShiftManagedClusterMasterPoolProfile masterPoolProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OpenShiftManagedClusterProperties();
        }
        this.innerProperties().withMasterPoolProfile(masterPoolProfile);
        return this;
    }

    public List<OpenShiftManagedClusterAgentPoolProfile> agentPoolProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().agentPoolProfiles();
    }

    public OpenShiftManagedClusterInner withAgentPoolProfiles(List<OpenShiftManagedClusterAgentPoolProfile> agentPoolProfiles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OpenShiftManagedClusterProperties();
        }
        this.innerProperties().withAgentPoolProfiles(agentPoolProfiles);
        return this;
    }

    public OpenShiftManagedClusterAuthProfile authProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().authProfile();
    }

    public OpenShiftManagedClusterInner withAuthProfile(OpenShiftManagedClusterAuthProfile authProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OpenShiftManagedClusterProperties();
        }
        this.innerProperties().withAuthProfile(authProfile);
        return this;
    }

    public void validate() {
        if (this.plan() != null) {
            this.plan().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

