/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid;

import io.github.bucket4j.Nothing;
import io.github.bucket4j.grid.GridBucketState;
import io.github.bucket4j.grid.GridCommand;
import io.github.bucket4j.serialization.DeserializationAdapter;
import io.github.bucket4j.serialization.SerializationAdapter;
import io.github.bucket4j.serialization.SerializationHandle;
import java.io.IOException;

public class ForceAddTokensCommand
implements GridCommand<Nothing> {
    private static final long serialVersionUID = 1L;
    private long tokensToAdd;
    public static final SerializationHandle<ForceAddTokensCommand> SERIALIZATION_HANDLE = new SerializationHandle<ForceAddTokensCommand>(){

        @Override
        public <S> ForceAddTokensCommand deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            long tokensToAdd = adapter.readLong(input);
            return new ForceAddTokensCommand(tokensToAdd);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, ForceAddTokensCommand command) throws IOException {
            adapter.writeLong(output, command.tokensToAdd);
        }

        @Override
        public int getTypeId() {
            return 26;
        }

        @Override
        public Class<ForceAddTokensCommand> getSerializedType() {
            return ForceAddTokensCommand.class;
        }
    };

    public ForceAddTokensCommand(long tokensToAdd) {
        this.tokensToAdd = tokensToAdd;
    }

    @Override
    public Nothing execute(GridBucketState state, long currentTimeNanos) {
        state.refillAllBandwidth(currentTimeNanos);
        state.forceAddTokens(this.tokensToAdd);
        return Nothing.INSTANCE;
    }

    @Override
    public boolean isBucketStateModified() {
        return true;
    }

    public long getTokensToAdd() {
        return this.tokensToAdd;
    }
}

