/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.base.server;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.dolphinscheduler.extract.base.server.ServerMethodInvoker;

class ServerMethodInvokerImpl
implements ServerMethodInvoker {
    private final Object serviceBean;
    private final Method method;
    private final String methodIdentify;
    private final List<Class<?>> parameterTypes;

    ServerMethodInvokerImpl(Object serviceBean, Method method) {
        this.serviceBean = serviceBean;
        this.method = method;
        this.methodIdentify = method.toGenericString();
        this.parameterTypes = Lists.newArrayList((Object[])method.getParameterTypes());
    }

    @Override
    public Object invoke(Object ... args) throws Throwable {
        try {
            return this.method.invoke(this.serviceBean, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    @Override
    public boolean isParameterTypeValidated(Class<?>[] argsTypes) {
        if (argsTypes == null || argsTypes.length == 0) {
            return this.parameterTypes.isEmpty();
        }
        if (this.parameterTypes.size() != argsTypes.length) {
            return false;
        }
        for (int i = 0; i < this.parameterTypes.size(); ++i) {
            Class<?> argType = argsTypes[i];
            if (argType == null || this.parameterTypes.get(i).isAssignableFrom(argType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getMethodIdentify() {
        return this.methodIdentify;
    }

    @Override
    public String getMethodProviderIdentify() {
        return this.serviceBean.getClass().getName();
    }
}

