/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appplatform.fluent.BuildpackBindingsClient;
import com.azure.resourcemanager.appplatform.fluent.models.BuildpackBindingResourceInner;
import com.azure.resourcemanager.appplatform.implementation.AppPlatformManagementClientImpl;
import com.azure.resourcemanager.appplatform.models.BuildpackBindingResourceCollection;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BuildpackBindingsClientImpl
implements BuildpackBindingsClient {
    private final BuildpackBindingsService service;
    private final AppPlatformManagementClientImpl client;

    BuildpackBindingsClientImpl(AppPlatformManagementClientImpl client) {
        this.service = (BuildpackBindingsService)RestProxy.create(BuildpackBindingsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BuildpackBindingResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (builderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter builderName is required and cannot be null."));
        }
        if (buildpackBindingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildpackBindingName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BuildpackBindingResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (builderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter builderName is required and cannot be null."));
        }
        if (buildpackBindingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildpackBindingName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BuildpackBindingResourceInner> getAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((BuildpackBindingResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BuildpackBindingResourceInner get(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName) {
        return (BuildpackBindingResourceInner)((Object)this.getAsync(resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BuildpackBindingResourceInner> getWithResponse(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName, BuildpackBindingResourceInner buildpackBinding) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (builderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter builderName is required and cannot be null."));
        }
        if (buildpackBindingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildpackBindingName is required and cannot be null."));
        }
        if (buildpackBinding == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildpackBinding is required and cannot be null."));
        }
        buildpackBinding.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName, buildpackBinding, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName, BuildpackBindingResourceInner buildpackBinding, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (builderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter builderName is required and cannot be null."));
        }
        if (buildpackBindingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildpackBindingName is required and cannot be null."));
        }
        if (buildpackBinding == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildpackBinding is required and cannot be null."));
        }
        buildpackBinding.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName, buildpackBinding, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<BuildpackBindingResourceInner>, BuildpackBindingResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName, BuildpackBindingResourceInner buildpackBinding) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName, buildpackBinding);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)BuildpackBindingResourceInner.class), (Type)((Object)BuildpackBindingResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BuildpackBindingResourceInner>, BuildpackBindingResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName, BuildpackBindingResourceInner buildpackBinding, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName, buildpackBinding, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)BuildpackBindingResourceInner.class), (Type)((Object)BuildpackBindingResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BuildpackBindingResourceInner>, BuildpackBindingResourceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName, BuildpackBindingResourceInner buildpackBinding) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName, buildpackBinding).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BuildpackBindingResourceInner>, BuildpackBindingResourceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName, BuildpackBindingResourceInner buildpackBinding, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName, buildpackBinding, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BuildpackBindingResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName, BuildpackBindingResourceInner buildpackBinding) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName, buildpackBinding).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BuildpackBindingResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName, BuildpackBindingResourceInner buildpackBinding, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName, buildpackBinding, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BuildpackBindingResourceInner createOrUpdate(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName, BuildpackBindingResourceInner buildpackBinding) {
        return (BuildpackBindingResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName, buildpackBinding).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BuildpackBindingResourceInner createOrUpdate(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName, BuildpackBindingResourceInner buildpackBinding, Context context) {
        return (BuildpackBindingResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName, buildpackBinding, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (builderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter builderName is required and cannot be null."));
        }
        if (buildpackBindingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildpackBindingName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (builderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter builderName is required and cannot be null."));
        }
        if (buildpackBindingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildpackBindingName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName) {
        this.deleteAsync(resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String buildServiceName, String builderName, String buildpackBindingName, Context context) {
        this.deleteAsync(resourceGroupName, serviceName, buildServiceName, builderName, buildpackBindingName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildpackBindingResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (builderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter builderName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, builderName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildpackBindingResourceCollection)res.getValue()).value(), ((BuildpackBindingResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildpackBindingResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (builderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter builderName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, builderName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildpackBindingResourceCollection)res.getValue()).value(), ((BuildpackBindingResourceCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BuildpackBindingResourceInner> listAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, serviceName, buildServiceName, builderName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BuildpackBindingResourceInner> listAsync(String resourceGroupName, String serviceName, String buildServiceName, String builderName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, serviceName, buildServiceName, builderName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BuildpackBindingResourceInner> list(String resourceGroupName, String serviceName, String buildServiceName, String builderName) {
        return new PagedIterable(this.listAsync(resourceGroupName, serviceName, buildServiceName, builderName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BuildpackBindingResourceInner> list(String resourceGroupName, String serviceName, String buildServiceName, String builderName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, serviceName, buildServiceName, builderName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildpackBindingResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildpackBindingResourceCollection)res.getValue()).value(), ((BuildpackBindingResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildpackBindingResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildpackBindingResourceCollection)res.getValue()).value(), ((BuildpackBindingResourceCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppPlatformManagemen")
    private static interface BuildpackBindingsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builders/{builderName}/buildpackBindings/{buildpackBindingName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuildpackBindingResourceInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @PathParam(value="builderName") String var7, @PathParam(value="buildpackBindingName") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builders/{builderName}/buildpackBindings/{buildpackBindingName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @PathParam(value="builderName") String var7, @PathParam(value="buildpackBindingName") String var8, @BodyParam(value="application/json") BuildpackBindingResourceInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builders/{builderName}/buildpackBindings/{buildpackBindingName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @PathParam(value="builderName") String var7, @PathParam(value="buildpackBindingName") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builders/{builderName}/buildpackBindings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuildpackBindingResourceCollection>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @PathParam(value="builderName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuildpackBindingResourceCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

