/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobOperation;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobResponseV2;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobsRequestV2;
import com.qcloud.cos.model.ciModel.job.v2.SegmentVideoBody;
import com.qcloud.cos.utils.Jackson;

public class SegmentVideoBodyJobDemo {
    public static void main(String[] args) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        SegmentVideoBodyJobDemo.createMediaJobs(client);
    }

    public static void createMediaJobs(COSClient client) throws JsonProcessingException {
        MediaJobsRequestV2 request = new MediaJobsRequestV2();
        request.setBucketName("demo-1234567890");
        request.setTag("SegmentVideoBody");
        request.getInput().setObject("1.mp4");
        MediaJobOperation operation = request.getOperation();
        SegmentVideoBody segmentVideoBody = operation.getSegmentVideoBody();
        segmentVideoBody.setMode("Mask");
        operation.setUserData("demodata");
        operation.setJobLevel("0");
        request.setCallBack("https://cloud.tencent.com/xxx");
        MediaOutputObject output = request.getOperation().getOutput();
        output.setBucket("demo-1234567890");
        output.setRegion("ap-chongqing");
        output.setObject("test/1.mp4");
        MediaJobResponseV2 response = client.createMediaJobsV2(request);
        System.out.println(response.getJobsDetail().getJobId());
    }

    public static void describeMediaJob(COSClient client) {
        MediaJobsRequestV2 request = new MediaJobsRequestV2();
        request.setBucketName("demo-1234567890");
        request.setJobId("a07707de43a6f11ee97dc5f2f0afe840e");
        MediaJobResponseV2 response = client.describeMediaJobV2(request);
        System.out.println(Jackson.toJsonString(response));
    }
}

