/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluent.models.ManagementLockObjectInner;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.implementation.ManagementLocksImpl;
import com.azure.resourcemanager.resources.models.LockLevel;
import com.azure.resourcemanager.resources.models.ManagementLock;
import com.azure.resourcemanager.resources.models.ManagementLockOwner;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.Mono;

final class ManagementLockImpl
extends CreatableUpdatableImpl<ManagementLock, ManagementLockObjectInner, ManagementLockImpl>
implements ManagementLock,
ManagementLock.Definition,
ManagementLock.Update {
    private final ResourceManager manager;
    private String lockedResourceId = null;
    private final ClientLogger logger = new ClientLogger(ManagementLockImpl.class);

    ManagementLockImpl(String name, ManagementLockObjectInner innerModel, ResourceManager manager) {
        super(name, innerModel);
        this.manager = manager;
    }

    @Override
    protected Mono<ManagementLockObjectInner> getInnerAsync() {
        return this.manager().managementLockClient().getManagementLocks().getByScopeAsync(this.lockedResourceId(), this.name());
    }

    @Override
    public ManagementLockImpl withNotes(String notes) {
        ((ManagementLockObjectInner)((Object)this.innerModel())).withNotes(notes);
        return this;
    }

    @Override
    public ManagementLockImpl withLevel(LockLevel level) {
        ((ManagementLockObjectInner)((Object)this.innerModel())).withLevel(level);
        return this;
    }

    @Override
    public ManagementLockImpl withLockedResource(String resourceId) {
        if (CoreUtils.isNullOrEmpty((CharSequence)resourceId)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing resource ID."));
        }
        this.lockedResourceId = resourceId;
        return this;
    }

    @Override
    public ManagementLockImpl withLockedResource(Resource resource) {
        if (resource == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing resource ID."));
        }
        this.lockedResourceId = resource.id();
        return this;
    }

    @Override
    public ManagementLockImpl withLockedResourceGroup(String resourceGroupName) {
        return this.withLockedResource("/subscriptions/" + this.manager().subscriptionId() + "/resourceGroups/" + resourceGroupName);
    }

    @Override
    public ManagementLockImpl withLockedResourceGroup(ResourceGroup resourceGroup) {
        if (resourceGroup == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing resource group ID."));
        }
        this.lockedResourceId = resourceGroup.id();
        return this;
    }

    @Override
    public ResourceManager manager() {
        return this.manager;
    }

    @Override
    public Mono<ManagementLock> createResourceAsync() {
        return this.manager().managementLockClient().getManagementLocks().createOrUpdateByScopeAsync(this.lockedResourceId(), this.name(), (ManagementLockObjectInner)((Object)this.innerModel())).map(this.innerToFluentMap(this));
    }

    @Override
    public boolean isInCreateMode() {
        return ((ManagementLockObjectInner)((Object)this.innerModel())).id() == null;
    }

    @Override
    public LockLevel level() {
        return ((ManagementLockObjectInner)((Object)this.innerModel())).level();
    }

    @Override
    public String lockedResourceId() {
        if (this.lockedResourceId == null) {
            this.lockedResourceId = ManagementLocksImpl.resourceIdFromLockId(((ManagementLockObjectInner)((Object)this.innerModel())).id());
        }
        return this.lockedResourceId;
    }

    @Override
    public String notes() {
        return ((ManagementLockObjectInner)((Object)this.innerModel())).notes();
    }

    @Override
    public List<ManagementLockOwner> owners() {
        if (((ManagementLockObjectInner)((Object)this.innerModel())).owners() == null) {
            return null;
        }
        return Collections.unmodifiableList(((ManagementLockObjectInner)((Object)this.innerModel())).owners());
    }

    @Override
    public String id() {
        return ((ManagementLockObjectInner)((Object)this.innerModel())).id();
    }
}

