/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.api.datasource;

import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Sets;
import com.google.common.net.InetAddresses;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourceProcessor
implements DataSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDataSourceProcessor.class);
    private static final Pattern IPV4_PATTERN = Pattern.compile("^[a-zA-Z0-9\\_\\-\\.\\,]+$");
    private static final Pattern IPV6_PATTERN = Pattern.compile("^[a-zA-Z0-9\\_\\-\\.\\:\\[\\]\\,]+$");
    private static final Pattern DATABASE_PATTER = Pattern.compile("^[a-zA-Z0-9\\_\\-\\.]+$");
    private static final Pattern PARAMS_PATTER = Pattern.compile("^[a-zA-Z0-9\\-\\_\\/\\@\\.\\:]+$");
    private static final Set<String> POSSIBLE_MALICIOUS_KEYS = Sets.newHashSet((Object[])new String[]{"allowLoadLocalInfile"});

    @Override
    public void checkDatasourceParam(BaseDataSourceParamDTO baseDataSourceParamDTO) {
        if (!baseDataSourceParamDTO.getType().equals((Object)DbType.REDSHIFT)) {
            this.checkHost(baseDataSourceParamDTO.getHost());
        }
        this.checkDatabasePatter(baseDataSourceParamDTO.getDatabase());
        this.checkOther(baseDataSourceParamDTO.getOther());
    }

    protected void checkHost(String host) {
        if (!(InetAddresses.isInetAddress((String)host) || IPV4_PATTERN.matcher(host).matches() && IPV6_PATTERN.matcher(host).matches())) {
            throw new IllegalArgumentException("datasource host illegal");
        }
    }

    protected void checkDatabasePatter(String database) {
        if (!DATABASE_PATTER.matcher(database).matches()) {
            throw new IllegalArgumentException("database name illegal");
        }
    }

    protected void checkOther(Map<String, String> other) {
        if (MapUtils.isEmpty(other)) {
            return;
        }
        if (!Sets.intersection(other.keySet(), POSSIBLE_MALICIOUS_KEYS).isEmpty()) {
            throw new IllegalArgumentException("Other params include possible malicious keys.");
        }
        for (Map.Entry<String, String> entry : other.entrySet()) {
            if (PARAMS_PATTER.matcher(entry.getKey()).matches()) continue;
            throw new IllegalArgumentException("datasource other params: " + entry.getKey() + " illegal");
        }
    }

    protected Map<String, String> transformOtherParamToMap(String other) {
        if (StringUtils.isBlank((CharSequence)other)) {
            return Collections.emptyMap();
        }
        return (Map)JSONUtils.parseObject((String)other, (TypeReference)new TypeReference<Map<String, String>>(){});
    }

    @Override
    public String getDatasourceUniqueId(ConnectionParam connectionParam, DbType dbType) {
        BaseConnectionParam baseConnectionParam = (BaseConnectionParam)connectionParam;
        return MessageFormat.format("{0}@{1}@{2}@{3}", dbType.getName(), baseConnectionParam.getUser(), PasswordUtils.encodePassword(baseConnectionParam.getPassword()), baseConnectionParam.getJdbcUrl());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkDataSourceConnectivity(ConnectionParam connectionParam) {
        try (Connection connection = this.getConnection(connectionParam);){
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Check datasource connectivity for: {} error", (Object)this.getDbType().name(), (Object)e);
            return false;
        }
    }

    @Override
    public List<String> splitAndRemoveComment(String sql) {
        String cleanSQL = SQLParserUtils.removeComment((String)sql, (com.alibaba.druid.DbType)com.alibaba.druid.DbType.other);
        return SQLParserUtils.split((String)cleanSQL, (com.alibaba.druid.DbType)com.alibaba.druid.DbType.other);
    }
}

