/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.scheduler.quartz;

import java.util.Date;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.scheduler.quartz.QuartzJobKey;
import org.apache.dolphinscheduler.scheduler.quartz.QuartzTriggerBuilder;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class QuartzCornTriggerBuilder
implements QuartzTriggerBuilder {
    private Integer projectId;
    private Schedule schedule;

    public static QuartzCornTriggerBuilder newBuilder() {
        return new QuartzCornTriggerBuilder();
    }

    public QuartzCornTriggerBuilder withProjectId(Integer projectId) {
        this.projectId = projectId;
        return this;
    }

    public QuartzCornTriggerBuilder withSchedule(Schedule schedule) {
        this.schedule = schedule;
        return this;
    }

    @Override
    public CronTrigger build() {
        if (this.projectId == null) {
            throw new IllegalArgumentException("projectId cannot be null");
        }
        if (this.schedule == null) {
            throw new IllegalArgumentException("schedule cannot be null");
        }
        Date startDate = DateUtils.transformTimezoneDate((Date)this.schedule.getStartTime(), (String)this.schedule.getTimezoneId());
        Date endDate = DateUtils.transformTimezoneDate((Date)this.schedule.getEndTime(), (String)this.schedule.getTimezoneId());
        Date now = new Date();
        if (startDate.before(now)) {
            startDate = now;
        }
        JobKey jobKey = QuartzJobKey.of(this.projectId, this.schedule.getId()).toJobKey();
        TriggerKey triggerKey = TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup());
        return (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerKey).startAt(startDate).endAt(endDate).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.schedule.getCrontab()).withMisfireHandlingInstructionIgnoreMisfires().inTimeZone(DateUtils.getTimezone((String)this.schedule.getTimezoneId()))).build();
    }
}

