/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.task.executor.eventbus;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.dolphinscheduler.common.exception.BaseException;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.log.TaskLogMarkers;
import org.apache.dolphinscheduler.task.executor.ITaskExecutor;
import org.apache.dolphinscheduler.task.executor.ITaskExecutorRepository;
import org.apache.dolphinscheduler.task.executor.eventbus.ITaskExecutorEventRemoteReporterClient;
import org.apache.dolphinscheduler.task.executor.eventbus.ITaskExecutorLifecycleEventReporter;
import org.apache.dolphinscheduler.task.executor.events.IReportableTaskExecutorLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorFinalizeLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorLifecycleEventType;
import org.apache.dolphinscheduler.task.executor.log.TaskExecutorMDCUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutorLifecycleEventRemoteReporter
extends BaseDaemonThread
implements ITaskExecutorLifecycleEventReporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecutorLifecycleEventRemoteReporter.class);
    private static final Long DEFAULT_TASK_EXECUTOR_EVENT_RETRY_INTERVAL = TimeUnit.MINUTES.toMillis(3L);
    private final String reporterName;
    private final Map<Integer, ReportableTaskExecutorLifecycleEventChannel> eventChannels = new ConcurrentHashMap<Integer, ReportableTaskExecutorLifecycleEventChannel>();
    private final ITaskExecutorEventRemoteReporterClient taskExecutorEventRemoteReporterClient;
    private volatile boolean runningFlag;
    private final Lock eventChannelsLock = new ReentrantLock();
    private final Condition taskExecutionEventEmptyCondition = this.eventChannelsLock.newCondition();
    private final ITaskExecutorRepository taskExecutorRepository;

    public TaskExecutorLifecycleEventRemoteReporter(String reporterName, ITaskExecutorEventRemoteReporterClient taskExecutorEventRemoteReporterClient, ITaskExecutorRepository taskExecutorRepository) {
        super(reporterName);
        this.reporterName = reporterName;
        this.taskExecutorEventRemoteReporterClient = taskExecutorEventRemoteReporterClient;
        this.taskExecutorRepository = taskExecutorRepository;
    }

    @Override
    public void start() {
        this.runningFlag = true;
        super.start();
        log.info("{} started", (Object)this.reporterName);
    }

    public void run() {
        while (this.runningFlag) {
            try {
                for (ReportableTaskExecutorLifecycleEventChannel eventChannel : this.eventChannels.values()) {
                    if (eventChannel.isEmpty()) continue;
                    this.handleTaskExecutionEventChannel(eventChannel);
                }
                this.tryToWaitIfAllTaskExecutionEventChannelEmpty();
                this.waitIfAnyTaskExecutionEventChannelRetryIntervalPassed();
            }
            catch (InterruptedException e) {
                log.info("{} interrupted", (Object)this.reporterName);
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception ex) {
                log.error("Fire ReportableTaskExecutorLifecycleEventChannel error", (Throwable)ex);
            }
        }
        log.info("{} break loop", (Object)this.reporterName);
    }

    @Override
    public void reportTaskExecutorLifecycleEvent(IReportableTaskExecutorLifecycleEvent reportableTaskExecutorLifecycleEvent) {
        this.eventChannelsLock.lock();
        try {
            log.info(TaskLogMarkers.excludeInTaskLog(), "Report : {}", (Object)JSONUtils.toPrettyJsonString((Object)reportableTaskExecutorLifecycleEvent));
            int taskInstanceId = reportableTaskExecutorLifecycleEvent.getTaskInstanceId();
            this.eventChannels.computeIfAbsent(taskInstanceId, k -> new ReportableTaskExecutorLifecycleEventChannel(taskInstanceId)).addTaskExecutionEvent(reportableTaskExecutorLifecycleEvent);
            this.taskExecutionEventEmptyCondition.signalAll();
        }
        finally {
            this.eventChannelsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveTaskExecutorLifecycleEventACK(ITaskExecutorLifecycleEventReporter.TaskExecutorLifecycleEventAck eventAck) {
        int taskExecutorId = eventAck.getTaskExecutorId();
        this.eventChannelsLock.lock();
        try {
            ReportableTaskExecutorLifecycleEventChannel eventChannel = this.eventChannels.get(taskExecutorId);
            if (eventChannel == null) {
                return;
            }
            IReportableTaskExecutorLifecycleEvent removed = eventChannel.remove(eventAck.getTaskExecutorLifecycleEventType());
            if (removed != null) {
                log.info("Success removed {} by ack: {}", (Object)removed, (Object)eventAck);
            } else {
                log.info("Failed removed ReportableTaskExecutorLifecycleEvent by ack: {}", (Object)eventAck);
            }
            if (eventChannel.isEmpty()) {
                if (removed != null && removed.getType().isFinished()) {
                    this.finalizeTaskExecutor(removed.getTaskInstanceId());
                }
                this.eventChannels.remove(taskExecutorId);
                log.debug("Removed ReportableTaskExecutorLifecycleEventChannel: {}", (Object)taskExecutorId);
            }
            this.taskExecutionEventEmptyCondition.signalAll();
        }
        finally {
            this.eventChannelsLock.unlock();
        }
    }

    @Override
    public void onWorkflowInstanceHostChanged(int taskInstanceId) {
        this.eventChannelsLock.lock();
        try {
            ReportableTaskExecutorLifecycleEventChannel eventChannel = this.eventChannels.get(taskInstanceId);
            if (eventChannel != null) {
                eventChannel.taskExecutionEventsQueue.forEach(event -> event.setLatestReportTime(null));
                this.taskExecutionEventEmptyCondition.signalAll();
            }
        }
        finally {
            this.eventChannelsLock.unlock();
        }
    }

    @Override
    public void close() {
        this.runningFlag = false;
        log.info("{} closed", (Object)this.reporterName);
    }

    @VisibleForTesting
    public Map<Integer, ReportableTaskExecutorLifecycleEventChannel> getEventChannels() {
        return this.eventChannels;
    }

    private void finalizeTaskExecutor(Integer taskExecutorId) {
        Optional<ITaskExecutor> taskExecutorOptional = this.taskExecutorRepository.get(taskExecutorId);
        if (taskExecutorOptional.isPresent()) {
            taskExecutorOptional.get().getTaskExecutorEventBus().publish(TaskExecutorFinalizeLifecycleEvent.of(taskExecutorOptional.get()));
        } else {
            log.warn("TaskExecutor is not exists: {}", (Object)taskExecutorId);
        }
    }

    private void handleTaskExecutionEventChannel(ReportableTaskExecutorLifecycleEventChannel reportableTaskExecutorLifecycleEventChannel) {
        if (reportableTaskExecutorLifecycleEventChannel.isEmpty()) {
            return;
        }
        while (!reportableTaskExecutorLifecycleEventChannel.isEmpty()) {
            IReportableTaskExecutorLifecycleEvent headEvent = reportableTaskExecutorLifecycleEventChannel.peek();
            TaskExecutorMDCUtils.MDCAutoClosable ignore = TaskExecutorMDCUtils.logWithMDC(headEvent.getTaskInstanceId());
            Throwable throwable = null;
            try {
                if (this.isTaskExecutorEventNeverSent(headEvent) || this.isRetryIntervalExceeded(headEvent)) {
                    Optional<ITaskExecutor> taskExecutorOptional = this.taskExecutorRepository.get(headEvent.getTaskInstanceId());
                    if (!taskExecutorOptional.isPresent()) {
                        throw new BaseException(String.format("The TaskExecutor id %d is not exist.", headEvent.getTaskInstanceId()));
                    }
                    String masterAddress = taskExecutorOptional.get().getTaskExecutionContext().getWorkflowInstanceHost();
                    this.taskExecutorEventRemoteReporterClient.reportTaskExecutionEventToMaster(masterAddress, headEvent);
                    continue;
                }
                if (!log.isDebugEnabled()) break;
                log.debug("The ReportableTaskExecutorLifecycleEvent: {} latest send time: {} doesn't exceeded retry interval", (Object)headEvent, (Object)headEvent.getLatestReportTime());
                break;
            }
            catch (Exception ex) {
                log.error("Send TaskExecutionEvent: {} to master error will retry after {} mills", new Object[]{headEvent, DEFAULT_TASK_EXECUTOR_EVENT_RETRY_INTERVAL, ex});
                break;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignore == null) continue;
                if (throwable != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignore.close();
            }
        }
    }

    private boolean isAllTaskExecutorEventChannelEmpty() {
        return this.eventChannels.values().stream().allMatch(ReportableTaskExecutorLifecycleEventChannel::isEmpty);
    }

    private long getOldestReportTime() {
        return this.eventChannels.values().stream().filter(ReportableTaskExecutorLifecycleEventChannel::isNotEmpty).map(ReportableTaskExecutorLifecycleEventChannel::peek).filter(event -> !this.isTaskExecutorEventNeverSent((IReportableTaskExecutorLifecycleEvent)event)).map(IReportableTaskExecutorLifecycleEvent::getLatestReportTime).min(Long::compareTo).orElse(0L);
    }

    private boolean isTaskExecutorEventNeverSent(IReportableTaskExecutorLifecycleEvent headEvent) {
        return headEvent.getLatestReportTime() == null;
    }

    private boolean isRetryIntervalExceeded(IReportableTaskExecutorLifecycleEvent reportableTaskExecutorLifecycleEvent) {
        if (this.isTaskExecutorEventNeverSent(reportableTaskExecutorLifecycleEvent)) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        return currentTime - reportableTaskExecutorLifecycleEvent.getLatestReportTime() > DEFAULT_TASK_EXECUTOR_EVENT_RETRY_INTERVAL;
    }

    private void tryToWaitIfAllTaskExecutionEventChannelEmpty() throws InterruptedException {
        this.eventChannelsLock.lock();
        while (this.isAllTaskExecutorEventChannelEmpty()) {
            this.taskExecutionEventEmptyCondition.await();
        }
        this.eventChannelsLock.unlock();
    }

    private void waitIfAnyTaskExecutionEventChannelRetryIntervalPassed() throws InterruptedException {
        this.eventChannelsLock.lock();
        try {
            long waitInterval = this.getOldestReportTime() + DEFAULT_TASK_EXECUTOR_EVENT_RETRY_INTERVAL - System.currentTimeMillis();
            if (waitInterval <= 0L) {
                return;
            }
            this.taskExecutionEventEmptyCondition.await(waitInterval, TimeUnit.MILLISECONDS);
        }
        finally {
            this.eventChannelsLock.unlock();
        }
    }

    public static class ReportableTaskExecutorLifecycleEventChannel {
        private final int taskExecutorId;
        private final LinkedBlockingQueue<IReportableTaskExecutorLifecycleEvent> taskExecutionEventsQueue;

        public ReportableTaskExecutorLifecycleEventChannel(int taskExecutorId) {
            this.taskExecutorId = taskExecutorId;
            this.taskExecutionEventsQueue = new LinkedBlockingQueue();
        }

        public void addTaskExecutionEvent(IReportableTaskExecutorLifecycleEvent reportableTaskExecutorLifecycleEvent) {
            this.taskExecutionEventsQueue.add(reportableTaskExecutorLifecycleEvent);
        }

        public IReportableTaskExecutorLifecycleEvent peek() {
            return this.taskExecutionEventsQueue.peek();
        }

        public IReportableTaskExecutorLifecycleEvent remove(TaskExecutorLifecycleEventType type) {
            AtomicReference removed = new AtomicReference();
            this.taskExecutionEventsQueue.removeIf(event -> {
                if (event.getType() == type) {
                    removed.set(event);
                    return true;
                }
                return false;
            });
            return (IReportableTaskExecutorLifecycleEvent)removed.get();
        }

        public boolean isEmpty() {
            return this.taskExecutionEventsQueue.isEmpty();
        }

        public boolean isNotEmpty() {
            return !this.isEmpty();
        }

        @Generated
        public int getTaskExecutorId() {
            return this.taskExecutorId;
        }
    }
}

