/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.auth;

import com.aliyun.oss.common.auth.BasicCredentials;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.HttpCredentialsFetcher;
import com.aliyun.oss.common.auth.InstanceProfileCredentials;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.HttpResponse;
import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class EcsRamRoleCredentialsFetcher
extends HttpCredentialsFetcher {
    private String ossAuthServerHost;

    public EcsRamRoleCredentialsFetcher(String ossAuthServerHost) {
        this.ossAuthServerHost = ossAuthServerHost;
    }

    @Override
    public URL buildUrl() throws ClientException {
        try {
            return new URL(this.ossAuthServerHost);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    @Override
    public Credentials parse(HttpResponse response) throws ClientException {
        String jsonContent = new String(response.getHttpContent());
        try {
            JSONObject jsonObject = new JSONObject(jsonContent);
            if (!jsonObject.has("Code")) {
                throw new ClientException("Invalid json " + jsonContent + " got from ecs metadata server.");
            }
            if (!"Success".equals(jsonObject.get("Code"))) {
                throw new ClientException("Failed to get credentials from ecs metadata server");
            }
            if (!jsonObject.has("AccessKeyId") || !jsonObject.has("AccessKeySecret")) {
                throw new ClientException("Invalid json " + jsonContent + " got from ecs metadata server.");
            }
            String securityToken = null;
            if (jsonObject.has("SecurityToken")) {
                securityToken = jsonObject.getString("SecurityToken");
            }
            if (jsonObject.has("Expiration")) {
                return new InstanceProfileCredentials(jsonObject.getString("AccessKeyId"), jsonObject.getString("AccessKeySecret"), securityToken, jsonObject.getString("Expiration")).withExpiredDuration(21600L).withExpiredFactor(0.85);
            }
            return new BasicCredentials(jsonObject.getString("AccessKeyId"), jsonObject.getString("AccessKeySecret"), securityToken);
        }
        catch (JSONException e) {
            throw new ClientException("EcsRamRoleCredentialsFetcher.parse [" + jsonContent + "] exception:" + (Object)((Object)e));
        }
    }
}

