/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnValueWireType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import com.azure.security.keyvault.secrets.SecretServiceVersion;
import com.azure.security.keyvault.secrets.implementation.DeletedSecretPage;
import com.azure.security.keyvault.secrets.implementation.KeyVaultErrorCodeStrings;
import com.azure.security.keyvault.secrets.implementation.SecretBackup;
import com.azure.security.keyvault.secrets.implementation.SecretPropertiesPage;
import com.azure.security.keyvault.secrets.implementation.SecretRequestAttributes;
import com.azure.security.keyvault.secrets.implementation.SecretRequestParameters;
import com.azure.security.keyvault.secrets.implementation.SecretRestoreRequestParameters;
import com.azure.security.keyvault.secrets.models.DeletedSecret;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.security.keyvault.secrets.models.SecretProperties;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public class SecretClientImpl {
    static final String ACCEPT_LANGUAGE = "en-US";
    static final int DEFAULT_MAX_PAGE_RESULTS = 25;
    static final String CONTENT_TYPE_HEADER_VALUE = "application/json";
    private static final String KEYVAULT_TRACING_NAMESPACE_VALUE = "Microsoft.KeyVault";
    private static final String HTTP_REST_PROXY_SYNC_PROXY_ENABLE = "com.azure.core.http.restproxy.syncproxy.enable";
    private static final Duration DEFAULT_POLLING_INTERVAL = Duration.ofSeconds(1L);
    private final String vaultUrl;
    private final SecretService service;
    private final ClientLogger logger = new ClientLogger(SecretClientImpl.class);
    private final HttpPipeline pipeline;
    private final SecretServiceVersion secretServiceVersion;

    public SecretClientImpl(String vaultUrl, HttpPipeline pipeline, SecretServiceVersion secretServiceVersion) {
        Objects.requireNonNull(vaultUrl, KeyVaultErrorCodeStrings.getErrorString("vault_endpoint_required"));
        this.vaultUrl = vaultUrl;
        this.service = (SecretService)RestProxy.create(SecretService.class, (HttpPipeline)pipeline);
        this.pipeline = pipeline;
        this.secretServiceVersion = secretServiceVersion;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    public HttpPipeline getHttpPipeline() {
        return this.pipeline;
    }

    public Duration getDefaultPollingInterval() {
        return DEFAULT_POLLING_INTERVAL;
    }

    public Mono<Response<KeyVaultSecret>> setSecretWithResponseAsync(KeyVaultSecret secret, Context context) {
        SecretRequestParameters parameters = this.validateAndCreateSetSecretParameters(secret);
        return this.service.setSecretAsync(this.vaultUrl, secret.getName(), this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Setting secret - {}", new Object[]{secret.getName()})).doOnSuccess(response -> this.logger.verbose("Set secret - {}", new Object[]{((KeyVaultSecret)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to set secret - {}", new Object[]{secret.getName(), error}));
    }

    public Response<KeyVaultSecret> setSecretWithResponse(KeyVaultSecret secret, Context context) {
        SecretRequestParameters parameters = this.validateAndCreateSetSecretParameters(secret);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.setSecret(this.vaultUrl, secret.getName(), this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    private SecretRequestParameters validateAndCreateSetSecretParameters(KeyVaultSecret secret) {
        Objects.requireNonNull(secret, "The Secret input parameter cannot be null.");
        return new SecretRequestParameters().setValue(secret.getValue()).setTags(secret.getProperties().getTags()).setContentType(secret.getProperties().getContentType()).setSecretAttributes(new SecretRequestAttributes(secret.getProperties()));
    }

    public Mono<Response<KeyVaultSecret>> setSecretWithResponseAsync(String name, String value, Context context) {
        SecretRequestParameters parameters = new SecretRequestParameters().setValue(value);
        return this.service.setSecretAsync(this.vaultUrl, name, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Setting secret - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Set secret - {}", new Object[]{((KeyVaultSecret)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to set secret - {}", new Object[]{name, error}));
    }

    public Response<KeyVaultSecret> setSecretWithResponse(String name, String value, Context context) {
        SecretRequestParameters parameters = new SecretRequestParameters().setValue(value);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.setSecret(this.vaultUrl, name, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    public Mono<Response<KeyVaultSecret>> getSecretWithResponseAsync(String name, String version, Context context) {
        return this.service.getSecretAsync(this.vaultUrl, name, version == null ? "" : version, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.verbose("Retrieving secret - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Retrieved secret - {}", new Object[]{((KeyVaultSecret)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to get secret - {}", new Object[]{name, error}));
    }

    public Response<KeyVaultSecret> getSecretWithResponse(String name, String version, Context context) {
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.getSecret(this.vaultUrl, name, version == null ? "" : version, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    public Mono<Response<SecretProperties>> updateSecretPropertiesWithResponseAsync(SecretProperties secretProperties, Context context) {
        SecretRequestParameters parameters = this.validateAndCreateUpdateSecretRequestParameters(secretProperties);
        return this.service.updateSecretAsync(this.vaultUrl, secretProperties.getName(), secretProperties.getVersion(), this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Updating secret - {}", new Object[]{secretProperties.getName()})).doOnSuccess(response -> this.logger.verbose("Updated secret - {}", new Object[]{((SecretProperties)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to update secret - {}", new Object[]{secretProperties.getName(), error}));
    }

    public Response<SecretProperties> updateSecretPropertiesWithResponse(SecretProperties secretProperties, Context context) {
        SecretRequestParameters parameters = this.validateAndCreateUpdateSecretRequestParameters(secretProperties);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.updateSecret(this.vaultUrl, secretProperties.getName(), secretProperties.getVersion(), this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    private SecretRequestParameters validateAndCreateUpdateSecretRequestParameters(SecretProperties secretProperties) {
        Objects.requireNonNull(secretProperties, "The secret properties input parameter cannot be null.");
        return new SecretRequestParameters().setTags(secretProperties.getTags()).setContentType(secretProperties.getContentType()).setSecretAttributes(new SecretRequestAttributes(secretProperties));
    }

    public PollerFlux<DeletedSecret, Void> beginDeleteSecretAsync(String name) {
        return new PollerFlux(this.getDefaultPollingInterval(), this.activationOperationAsync(name), this.createPollOperationAsync(name), (pollingContext, firstResponse) -> Mono.empty(), pollingContext -> Mono.empty());
    }

    public SyncPoller<DeletedSecret, Void> beginDeleteSecret(String name, Context context) {
        return SyncPoller.createPoller((Duration)this.getDefaultPollingInterval(), cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.activationOperation(name, context).apply((PollingContext<DeletedSecret>)cxt)), this.createPollOperation(name, context), (pollingContext, firstResponse) -> null, pollingContext -> null);
    }

    private Function<PollingContext<DeletedSecret>, Mono<DeletedSecret>> activationOperationAsync(String name) {
        return pollingContext -> FluxUtil.withContext(context -> this.deleteSecretWithResponseAsync(name, (Context)context)).flatMap(deletedSecretResponse -> Mono.just((Object)((DeletedSecret)deletedSecretResponse.getValue())));
    }

    private Function<PollingContext<DeletedSecret>, DeletedSecret> activationOperation(String name, Context context) {
        return pollingContext -> (DeletedSecret)this.deleteSecretWithResponse(name, context).getValue();
    }

    private Function<PollingContext<DeletedSecret>, Mono<PollResponse<DeletedSecret>>> createPollOperationAsync(String keyName) {
        return pollingContext -> FluxUtil.withContext(context -> this.service.getDeletedSecretPollerAsync(this.vaultUrl, keyName, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE))).flatMap(deletedSecretResponse -> {
            if (deletedSecretResponse.getStatusCode() == 404) {
                return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((DeletedSecret)pollingContext.getLatestResponse().getValue()))));
            }
            return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedSecret)deletedSecretResponse.getValue()))));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedSecret)pollingContext.getLatestResponse().getValue())));
    }

    private Function<PollingContext<DeletedSecret>, PollResponse<DeletedSecret>> createPollOperation(String keyName, Context context) {
        return pollingContext -> {
            try {
                Context contextToUse = context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE);
                contextToUse = this.enableSyncRestProxy(contextToUse);
                Response<DeletedSecret> deletedSecretResponse = this.service.getDeletedSecretPoller(this.vaultUrl, keyName, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, contextToUse);
                if (deletedSecretResponse.getStatusCode() == 404) {
                    return new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((DeletedSecret)pollingContext.getLatestResponse().getValue()));
                }
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedSecret)deletedSecretResponse.getValue()));
            }
            catch (HttpResponseException e) {
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedSecret)pollingContext.getLatestResponse().getValue()));
            }
        };
    }

    private Mono<Response<DeletedSecret>> deleteSecretWithResponseAsync(String name, Context context) {
        return this.service.deleteSecretAsync(this.vaultUrl, name, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Deleting secret - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Deleted secret - {}", new Object[]{((DeletedSecret)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to delete secret - {}", new Object[]{name, error}));
    }

    private Response<DeletedSecret> deleteSecretWithResponse(String name, Context context) {
        context = this.enableSyncRestProxy(context);
        return this.service.deleteSecret(this.vaultUrl, name, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    public Mono<Response<DeletedSecret>> getDeletedSecretWithResponseAsync(String name, Context context) {
        return this.service.getDeletedSecretAsync(this.vaultUrl, name, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Retrieving deleted secret - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Retrieved deleted secret - {}", new Object[]{((DeletedSecret)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to retrieve deleted secret - {}", new Object[]{name, error}));
    }

    public Response<DeletedSecret> getDeletedSecretWithResponse(String name, Context context) {
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.getDeletedSecret(this.vaultUrl, name, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    public Mono<Response<Void>> purgeDeletedSecretWithResponseAsync(String name, Context context) {
        return this.service.purgeDeletedSecretAsync(this.vaultUrl, name, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Purging deleted secret - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Purged deleted secret - {}", new Object[]{name})).doOnError(error -> this.logger.warning("Failed to purge deleted secret - {}", new Object[]{name, error}));
    }

    public Response<Void> purgeDeletedSecretWithResponse(String name, Context context) {
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.purgeDeletedSecret(this.vaultUrl, name, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    public PollerFlux<KeyVaultSecret, Void> beginRecoverDeletedSecretAsync(String name) {
        return new PollerFlux(this.getDefaultPollingInterval(), this.recoverActivationOperation(name), this.createRecoverPollOperation(name), (pollerContext, firstResponse) -> Mono.empty(), pollingContext -> Mono.empty());
    }

    private Function<PollingContext<KeyVaultSecret>, Mono<KeyVaultSecret>> recoverActivationOperation(String name) {
        return pollingContext -> FluxUtil.withContext(context -> this.recoverDeletedSecretWithResponseAsync(name, (Context)context)).flatMap(keyResponse -> Mono.just((Object)((KeyVaultSecret)keyResponse.getValue())));
    }

    private Function<PollingContext<KeyVaultSecret>, Mono<PollResponse<KeyVaultSecret>>> createRecoverPollOperation(String secretName) {
        return pollingContext -> FluxUtil.withContext(context -> this.service.getSecretPollerAsync(this.vaultUrl, secretName, "", this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE))).flatMap(secretResponse -> {
            if (secretResponse.getStatusCode() == 404) {
                return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((KeyVaultSecret)pollingContext.getLatestResponse().getValue()))));
            }
            return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultSecret)secretResponse.getValue()))));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultSecret)pollingContext.getLatestResponse().getValue())));
    }

    private Mono<Response<KeyVaultSecret>> recoverDeletedSecretWithResponseAsync(String name, Context context) {
        return this.service.recoverDeletedSecretAsync(this.vaultUrl, name, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Recovering deleted secret - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Recovered deleted secret - {}", new Object[]{((KeyVaultSecret)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to recover deleted secret - {}", new Object[]{name, error}));
    }

    public Mono<Response<byte[]>> backupSecretWithResponseAsync(String name, Context context) {
        return this.service.backupSecretAsync(this.vaultUrl, name, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Backing up secret - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Backed up secret - {}", new Object[]{name})).doOnError(error -> this.logger.warning("Failed to back up secret - {}", new Object[]{name, error})).flatMap(base64URLResponse -> Mono.just((Object)new SimpleResponse(base64URLResponse.getRequest(), base64URLResponse.getStatusCode(), base64URLResponse.getHeaders(), (Object)((SecretBackup)base64URLResponse.getValue()).getValue())));
    }

    public Response<byte[]> backupSecretWithResponse(String name, Context context) {
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        Response<SecretBackup> secretBackupResponse = this.service.backupSecret(this.vaultUrl, name, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
        return new SimpleResponse(secretBackupResponse.getRequest(), secretBackupResponse.getStatusCode(), secretBackupResponse.getHeaders(), (Object)((SecretBackup)secretBackupResponse.getValue()).getValue());
    }

    public Mono<Response<KeyVaultSecret>> restoreSecretBackupWithResponseAsync(byte[] backup, Context context) {
        SecretRestoreRequestParameters parameters = new SecretRestoreRequestParameters().setSecretBackup(backup);
        return this.service.restoreSecretAsync(this.vaultUrl, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Attempting to restore secret")).doOnSuccess(response -> this.logger.verbose("Restored secret - {}", new Object[]{((KeyVaultSecret)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to restore secret", new Object[]{error}));
    }

    public Response<KeyVaultSecret> restoreSecretBackupWithResponse(byte[] backup, Context context) {
        SecretRestoreRequestParameters parameters = new SecretRestoreRequestParameters().setSecretBackup(backup);
        context = context == null ? Context.NONE : context;
        context = this.enableSyncRestProxy(context);
        return this.service.restoreSecret(this.vaultUrl, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE));
    }

    public PagedFlux<SecretProperties> listPropertiesOfSecrets() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(this::listSecretsFirstPage), continuationToken -> FluxUtil.withContext(context -> this.listSecretsNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    public PagedFlux<SecretProperties> listPropertiesOfSecrets(Context context) {
        return new PagedFlux(() -> this.listSecretsFirstPage(context), continuationToken -> this.listSecretsNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<SecretProperties>> listSecretsFirstPage(Context context) {
        try {
            return this.service.getSecretsAsync(this.vaultUrl, 25, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing secrets")).doOnSuccess(response -> this.logger.verbose("Listed secrets")).doOnError(error -> this.logger.warning("Failed to list secrets", new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<SecretProperties>> listSecretsNextPage(String continuationToken, Context context) {
        try {
            return this.service.getSecretsAsync(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.verbose("Retrieving the next secrets page - Page {}", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.verbose("Retrieved the next secrets page - Page {}", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to retrieve the next secrets page - Page {}", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public PagedFlux<DeletedSecret> listDeletedSecrets() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(this::listDeletedSecretsFirstPage), continuationToken -> FluxUtil.withContext(context -> this.listDeletedSecretsNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    public PagedFlux<DeletedSecret> listDeletedSecrets(Context context) {
        return new PagedFlux(() -> this.listDeletedSecretsFirstPage(context), continuationToken -> this.listDeletedSecretsNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<DeletedSecret>> listDeletedSecretsFirstPage(Context context) {
        try {
            return this.service.getDeletedSecretsAsync(this.vaultUrl, 25, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing deleted secrets")).doOnSuccess(response -> this.logger.verbose("Listed deleted secrets")).doOnError(error -> this.logger.warning("Failed to list deleted secrets", new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<DeletedSecret>> listDeletedSecretsNextPage(String continuationToken, Context context) {
        try {
            return this.service.getDeletedSecretsAsync(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.verbose("Retrieving the next deleted secrets page - Page {}", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.verbose("Retrieved the next deleted secrets page - Page {}", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to retrieve the next deleted secrets page - Page {}", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public PagedFlux<SecretProperties> listPropertiesOfSecretVersions(String name) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listSecretVersionsFirstPage(name, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listSecretVersionsNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    public PagedFlux<SecretProperties> listPropertiesOfSecretVersions(String name, Context context) {
        return new PagedFlux(() -> this.listSecretVersionsFirstPage(name, context), continuationToken -> this.listSecretVersionsNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<SecretProperties>> listSecretVersionsFirstPage(String name, Context context) {
        try {
            return this.service.getSecretVersionsAsync(this.vaultUrl, name, 25, this.secretServiceVersion.getVersion(), ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing secret versions - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Listed secret versions - {}", new Object[]{name})).doOnError(error -> this.logger.warning("Failed to list secret versions - {}", new Object[]{name, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<SecretProperties>> listSecretVersionsNextPage(String continuationToken, Context context) {
        try {
            return this.service.getSecretsAsync(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.verbose("Retrieving the next secrets versions page - Page {}", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.verbose("Retrieved the next secrets versions page - Page {}", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to retrieve the next secrets versions page - Page {}", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Context enableSyncRestProxy(Context context) {
        return context.addData((Object)HTTP_REST_PROXY_SYNC_PROXY_ENABLE, (Object)true);
    }

    @Host(value="{url}")
    @ServiceInterface(name="KeyVault")
    public static interface SecretService {
        @Put(value="secrets/{secret-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<KeyVaultSecret>> setSecretAsync(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") SecretRequestParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Put(value="secrets/{secret-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<KeyVaultSecret> setSecret(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") SecretRequestParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="secrets/{secret-name}/{secret-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<KeyVaultSecret>> getSecretAsync(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @PathParam(value="secret-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="secrets/{secret-name}/{secret-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<KeyVaultSecret> getSecret(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @PathParam(value="secret-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="secrets/{secret-name}/{secret-version}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<KeyVaultSecret>> getSecretPollerAsync(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @PathParam(value="secret-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="secrets/{secret-name}/{secret-version}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<KeyVaultSecret> getSecretPoller(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @PathParam(value="secret-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Patch(value="secrets/{secret-name}/{secret-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<SecretProperties>> updateSecretAsync(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @PathParam(value="secret-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @BodyParam(value="application/json") SecretRequestParameters var6, @HeaderParam(value="Content-Type") String var7, Context var8);

        @Patch(value="secrets/{secret-name}/{secret-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Response<SecretProperties> updateSecret(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @PathParam(value="secret-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @BodyParam(value="application/json") SecretRequestParameters var6, @HeaderParam(value="Content-Type") String var7, Context var8);

        @Delete(value="secrets/{secret-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<DeletedSecret>> deleteSecretAsync(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Delete(value="secrets/{secret-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<DeletedSecret> deleteSecret(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="deletedsecrets/{secret-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<DeletedSecret>> getDeletedSecretAsync(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="deletedsecrets/{secret-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<DeletedSecret> getDeletedSecret(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="deletedsecrets/{secret-name}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<DeletedSecret>> getDeletedSecretPollerAsync(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="deletedsecrets/{secret-name}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Response<DeletedSecret> getDeletedSecretPoller(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Delete(value="deletedsecrets/{secret-name}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> purgeDeletedSecretAsync(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Delete(value="deletedsecrets/{secret-name}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> purgeDeletedSecret(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Post(value="deletedsecrets/{secret-name}/recover")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<KeyVaultSecret>> recoverDeletedSecretAsync(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Post(value="deletedsecrets/{secret-name}/recover")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<KeyVaultSecret> recoverDeletedSecret(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Post(value="secrets/{secret-name}/backup")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<SecretBackup>> backupSecretAsync(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Post(value="secrets/{secret-name}/backup")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<SecretBackup> backupSecret(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Post(value="secrets/restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<KeyVaultSecret>> restoreSecretAsync(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @BodyParam(value="application/json") SecretRestoreRequestParameters var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Post(value="secrets/restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<KeyVaultSecret> restoreSecret(@HostParam(value="url") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept-language") String var3, @BodyParam(value="application/json") SecretRestoreRequestParameters var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="secrets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=SecretPropertiesPage.class)
        public Mono<PagedResponse<SecretProperties>> getSecretsAsync(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="secrets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=SecretPropertiesPage.class)
        public PagedResponse<SecretProperties> getSecrets(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="secrets/{secret-name}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=SecretPropertiesPage.class)
        public Mono<PagedResponse<SecretProperties>> getSecretVersionsAsync(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="maxresults") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="secrets/{secret-name}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=SecretPropertiesPage.class)
        public PagedResponse<SecretProperties> getSecretVersions(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="maxresults") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Get(value="{nextUrl}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=SecretPropertiesPage.class)
        public Mono<PagedResponse<SecretProperties>> getSecretsAsync(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

        @Get(value="{nextUrl}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=SecretPropertiesPage.class)
        public PagedResponse<SecretProperties> getSecrets(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

        @Get(value="deletedsecrets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=DeletedSecretPage.class)
        public Mono<PagedResponse<DeletedSecret>> getDeletedSecretsAsync(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="deletedsecrets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=DeletedSecretPage.class)
        public PagedResponse<DeletedSecret> getDeletedSecrets(@HostParam(value="url") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @HeaderParam(value="Content-Type") String var5, Context var6);

        @Get(value="{nextUrl}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=DeletedSecretPage.class)
        public Mono<PagedResponse<DeletedSecret>> getDeletedSecretsAsync(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);

        @Get(value="{nextUrl}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        @ReturnValueWireType(value=DeletedSecretPage.class)
        public PagedResponse<DeletedSecret> getDeletedSecrets(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Content-Type") String var4, Context var5);
    }
}

