/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.log.remote;

import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogHandler;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogHandlerFactory;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogService;
import org.apache.dolphinscheduler.common.utils.LogUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RemoteLogUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemoteLogUtils.class);
    private static RemoteLogService remoteLogService;
    @Autowired
    private RemoteLogService autowiredRemoteLogService;

    @PostConstruct
    private void init() {
        remoteLogService = this.autowiredRemoteLogService;
    }

    public static void sendRemoteLog(String logPath) {
        if (RemoteLogUtils.isRemoteLoggingEnable()) {
            remoteLogService.asyncSendRemoteLog(logPath);
        }
    }

    public static void getRemoteLog(String logPath) {
        if (RemoteLogUtils.isRemoteLoggingEnable()) {
            log.info("Start to get log {} from remote target {}", (Object)logPath, (Object)PropertyUtils.getString("remote.logging.target"));
            RemoteLogUtils.mkdirOfLog(logPath);
            RemoteLogHandler remoteLogHandler = RemoteLogHandlerFactory.getRemoteLogHandler();
            if (remoteLogHandler == null) {
                return;
            }
            remoteLogHandler.getRemoteLog(logPath);
            log.info("End get log {} from remote target {}", (Object)logPath, (Object)PropertyUtils.getString("remote.logging.target"));
        }
    }

    private static void mkdirOfLog(String logPath) {
        Path directory = Paths.get(logPath, new String[0]).getParent();
        directory.toFile().mkdirs();
    }

    public static boolean isRemoteLoggingEnable() {
        return PropertyUtils.getBoolean("remote.logging.enable", Boolean.FALSE);
    }

    public static String getObjectNameFromLogPath(String logPath) {
        Path localLogBaseDirPath = Paths.get(LogUtils.getLocalLogBaseDir(), new String[0]).toAbsolutePath();
        Path path = Paths.get(logPath, new String[0]);
        int nameCount = path.getNameCount();
        String remoteLogBaseDir = PropertyUtils.getString("remote.logging.base.dir");
        return Paths.get(remoteLogBaseDir, path.subpath(localLogBaseDirPath.getNameCount(), nameCount).toString()).toString();
    }
}

