/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import lombok.NonNull;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.dolphinscheduler.common.model.OkHttpRequestHeaderContentType;
import org.apache.dolphinscheduler.common.model.OkHttpRequestHeaders;
import org.apache.dolphinscheduler.common.model.OkHttpResponse;
import org.apache.dolphinscheduler.common.utils.JSONUtils;

public class OkHttpUtils {
    private static OkHttpClient CLIENT = new OkHttpClient();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public static OkHttpResponse get(@NonNull String url, @Nullable OkHttpRequestHeaders okHttpRequestHeaders, @Nullable Map<String, Object> requestParams, int connectTimeout, int writeTimeout, int readTimeout) throws IOException {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        OkHttpClient client = OkHttpUtils.getHttpClient(connectTimeout, writeTimeout, readTimeout);
        String finalUrl = OkHttpUtils.addUrlParams(requestParams, url);
        Request.Builder requestBuilder = new Request.Builder().url(finalUrl);
        OkHttpUtils.addHeader(okHttpRequestHeaders.getHeaders(), requestBuilder);
        Request request = requestBuilder.build();
        try (Response response = client.newCall(request).execute();){
            OkHttpResponse okHttpResponse = new OkHttpResponse(response.code(), OkHttpUtils.getResponseBody(response));
            return okHttpResponse;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Get request execute failed, url: %s", url), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public static OkHttpResponse post(@NonNull String url, @Nullable OkHttpRequestHeaders okHttpRequestHeaders, @Nullable Map<String, Object> requestParamsMap, @Nullable Map<String, Object> requestBodyMap, int connectTimeout, int writeTimeout, int readTimeout) throws IOException {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        OkHttpClient client = OkHttpUtils.getHttpClient(connectTimeout, writeTimeout, readTimeout);
        String finalUrl = OkHttpUtils.addUrlParams(requestParamsMap, url);
        Request.Builder requestBuilder = new Request.Builder().url(finalUrl);
        OkHttpUtils.addHeader(okHttpRequestHeaders.getHeaders(), requestBuilder);
        if (requestBodyMap != null) {
            requestBuilder = requestBuilder.post(RequestBody.create((String)JSONUtils.toJsonString(requestBodyMap), (MediaType)MediaType.parse((String)okHttpRequestHeaders.getOkHttpRequestHeaderContentType().getValue())));
        }
        try (Response response = client.newCall(requestBuilder.build()).execute();){
            OkHttpResponse okHttpResponse = new OkHttpResponse(response.code(), OkHttpUtils.getResponseBody(response));
            return okHttpResponse;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Post request execute failed, url: %s", url), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public static OkHttpResponse put(@NonNull String url, @Nullable OkHttpRequestHeaders okHttpRequestHeaders, @Nullable Map<String, Object> requestBodyMap, int connectTimeout, int writeTimeout, int readTimeout) throws IOException {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        OkHttpClient client = OkHttpUtils.getHttpClient(connectTimeout, writeTimeout, readTimeout);
        Request.Builder requestBuilder = new Request.Builder().url(url);
        OkHttpUtils.addHeader(okHttpRequestHeaders.getHeaders(), requestBuilder);
        if (requestBodyMap != null) {
            requestBuilder = requestBuilder.put(RequestBody.create((String)JSONUtils.toJsonString(requestBodyMap), (MediaType)MediaType.parse((String)okHttpRequestHeaders.getOkHttpRequestHeaderContentType().getValue())));
        }
        try (Response response = client.newCall(requestBuilder.build()).execute();){
            OkHttpResponse okHttpResponse = new OkHttpResponse(response.code(), OkHttpUtils.getResponseBody(response));
            return okHttpResponse;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Put request execute failed, url: %s", url), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public static OkHttpResponse delete(@NonNull String url, @Nullable OkHttpRequestHeaders okHttpRequestHeaders, int connectTimeout, int writeTimeout, int readTimeout) throws IOException {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        OkHttpClient client = OkHttpUtils.getHttpClient(connectTimeout, writeTimeout, readTimeout);
        Request.Builder requestBuilder = new Request.Builder().url(url);
        OkHttpUtils.addHeader(okHttpRequestHeaders.getHeaders(), requestBuilder);
        requestBuilder = requestBuilder.delete();
        try (Response response = client.newCall(requestBuilder.build()).execute();){
            OkHttpResponse okHttpResponse = new OkHttpResponse(response.code(), OkHttpUtils.getResponseBody(response));
            return okHttpResponse;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Delete request execute failed, url: %s", url), e);
        }
    }

    @NonNull
    public static String demoPost(@NonNull String url, @Nullable String token, @Nullable Map<String, Object> requestBodyMap) throws IOException {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        StringBuilder stringBuffer = new StringBuilder();
        if (requestBodyMap != null) {
            for (String key : requestBodyMap.keySet()) {
                stringBuffer.append(key).append("=").append(requestBodyMap.get(key)).append("&");
            }
        }
        RequestBody body = RequestBody.create((String)stringBuffer.toString(), (MediaType)MediaType.parse((String)OkHttpRequestHeaderContentType.APPLICATION_FORM_URLENCODED.getValue()));
        Request request = new Request.Builder().url(url).header("token", token).addHeader("accpect", "application/json").post(body).build();
        OkHttpClient client = OkHttpUtils.getHttpClient(60000, 60000, 60000);
        try (Response response = client.newCall(request).execute();){
            String string = response.body().string();
            return string;
        }
    }

    private static String addUrlParams(@Nullable Map<String, Object> requestParams, @NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (requestParams == null) {
            return url;
        }
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null) {
            throw new IllegalArgumentException(String.format("url: %s is invalid", url));
        }
        HttpUrl.Builder urlBuilder = httpUrl.newBuilder();
        for (Map.Entry<String, Object> entry : requestParams.entrySet()) {
            urlBuilder.addQueryParameter(entry.getKey(), entry.getValue().toString());
        }
        return urlBuilder.toString();
    }

    private static void addHeader(@Nullable Map<String, String> headers, @NonNull Request.Builder requestBuilder) {
        if (requestBuilder == null) {
            throw new NullPointerException("requestBuilder is marked non-null but is null");
        }
        if (headers == null) {
            return;
        }
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
    }

    private static String getResponseBody(@NonNull Response response) throws IOException {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (response.code() != 200 || response.body() == null) {
            return String.format("Request execute failed, httpCode: %s, httpBody: %s", response.code(), response.body());
        }
        return response.body().string();
    }

    private static OkHttpClient getHttpClient(int connectTimeout, int writeTimeout, int readTimeout) {
        return CLIENT.newBuilder().connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)writeTimeout, TimeUnit.MILLISECONDS).readTimeout((long)readTimeout, TimeUnit.MILLISECONDS).build();
    }
}

