/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.resourcemanager.appplatform.models.AppResourceProvisioningState;
import com.azure.resourcemanager.appplatform.models.LoadedCertificate;
import com.azure.resourcemanager.appplatform.models.PersistentDisk;
import com.azure.resourcemanager.appplatform.models.TemporaryDisk;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class AppResourceProperties {
    @JsonProperty(value="public")
    private Boolean publicProperty;
    @JsonProperty(value="url", access=JsonProperty.Access.WRITE_ONLY)
    private String url;
    @JsonProperty(value="addonConfigs")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, Map<String, Object>> addonConfigs;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private AppResourceProvisioningState provisioningState;
    @JsonProperty(value="fqdn")
    private String fqdn;
    @JsonProperty(value="httpsOnly")
    private Boolean httpsOnly;
    @JsonProperty(value="temporaryDisk")
    private TemporaryDisk temporaryDisk;
    @JsonProperty(value="persistentDisk")
    private PersistentDisk persistentDisk;
    @JsonProperty(value="enableEndToEndTLS")
    private Boolean enableEndToEndTls;
    @JsonProperty(value="loadedCertificates")
    private List<LoadedCertificate> loadedCertificates;

    public Boolean publicProperty() {
        return this.publicProperty;
    }

    public AppResourceProperties withPublicProperty(Boolean publicProperty) {
        this.publicProperty = publicProperty;
        return this;
    }

    public String url() {
        return this.url;
    }

    public Map<String, Map<String, Object>> addonConfigs() {
        return this.addonConfigs;
    }

    public AppResourceProperties withAddonConfigs(Map<String, Map<String, Object>> addonConfigs) {
        this.addonConfigs = addonConfigs;
        return this;
    }

    public AppResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public AppResourceProperties withFqdn(String fqdn) {
        this.fqdn = fqdn;
        return this;
    }

    public Boolean httpsOnly() {
        return this.httpsOnly;
    }

    public AppResourceProperties withHttpsOnly(Boolean httpsOnly) {
        this.httpsOnly = httpsOnly;
        return this;
    }

    public TemporaryDisk temporaryDisk() {
        return this.temporaryDisk;
    }

    public AppResourceProperties withTemporaryDisk(TemporaryDisk temporaryDisk) {
        this.temporaryDisk = temporaryDisk;
        return this;
    }

    public PersistentDisk persistentDisk() {
        return this.persistentDisk;
    }

    public AppResourceProperties withPersistentDisk(PersistentDisk persistentDisk) {
        this.persistentDisk = persistentDisk;
        return this;
    }

    public Boolean enableEndToEndTls() {
        return this.enableEndToEndTls;
    }

    public AppResourceProperties withEnableEndToEndTls(Boolean enableEndToEndTls) {
        this.enableEndToEndTls = enableEndToEndTls;
        return this;
    }

    public List<LoadedCertificate> loadedCertificates() {
        return this.loadedCertificates;
    }

    public AppResourceProperties withLoadedCertificates(List<LoadedCertificate> loadedCertificates) {
        this.loadedCertificates = loadedCertificates;
        return this;
    }

    public void validate() {
        if (this.temporaryDisk() != null) {
            this.temporaryDisk().validate();
        }
        if (this.persistentDisk() != null) {
            this.persistentDisk().validate();
        }
        if (this.loadedCertificates() != null) {
            this.loadedCertificates().forEach(e -> e.validate());
        }
    }
}

