/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.entity;

import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.CycleEnum;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentItem;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentTaskModel;
import org.apache.dolphinscheduler.plugin.task.api.parameters.DependentParameters;

public class DependentWorkflowDefinition {
    private long workflowDefinitionCode;
    private int workflowDefinitionVersion;
    private long taskDefinitionCode;
    private String taskParams;
    private String workerGroup;

    public CycleEnum getDependentCycle(long upstreamProcessDefinitionCode) {
        DependentParameters dependentParameters = this.getDependentParameters();
        List dependentTaskModelList = dependentParameters.getDependence().getDependTaskList();
        for (DependentTaskModel dependentTaskModel : dependentTaskModelList) {
            List dependentItemList = dependentTaskModel.getDependItemList();
            for (DependentItem dependentItem : dependentItemList) {
                if (upstreamProcessDefinitionCode != dependentItem.getDefinitionCode()) continue;
                return this.cycle2CycleEnum(dependentItem.getCycle());
            }
        }
        return CycleEnum.DAY;
    }

    public CycleEnum cycle2CycleEnum(String cycle) {
        CycleEnum cycleEnum = null;
        switch (cycle) {
            case "day": {
                cycleEnum = CycleEnum.DAY;
                break;
            }
            case "hour": {
                cycleEnum = CycleEnum.HOUR;
                break;
            }
            case "week": {
                cycleEnum = CycleEnum.WEEK;
                break;
            }
            case "month": {
                cycleEnum = CycleEnum.MONTH;
                break;
            }
        }
        return cycleEnum;
    }

    public DependentParameters getDependentParameters() {
        return (DependentParameters)JSONUtils.parseObject((String)this.taskParams, DependentParameters.class);
    }

    @Generated
    public DependentWorkflowDefinition() {
    }

    @Generated
    public long getWorkflowDefinitionCode() {
        return this.workflowDefinitionCode;
    }

    @Generated
    public int getWorkflowDefinitionVersion() {
        return this.workflowDefinitionVersion;
    }

    @Generated
    public long getTaskDefinitionCode() {
        return this.taskDefinitionCode;
    }

    @Generated
    public String getTaskParams() {
        return this.taskParams;
    }

    @Generated
    public String getWorkerGroup() {
        return this.workerGroup;
    }

    @Generated
    public void setWorkflowDefinitionCode(long workflowDefinitionCode) {
        this.workflowDefinitionCode = workflowDefinitionCode;
    }

    @Generated
    public void setWorkflowDefinitionVersion(int workflowDefinitionVersion) {
        this.workflowDefinitionVersion = workflowDefinitionVersion;
    }

    @Generated
    public void setTaskDefinitionCode(long taskDefinitionCode) {
        this.taskDefinitionCode = taskDefinitionCode;
    }

    @Generated
    public void setTaskParams(String taskParams) {
        this.taskParams = taskParams;
    }

    @Generated
    public void setWorkerGroup(String workerGroup) {
        this.workerGroup = workerGroup;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependentWorkflowDefinition)) {
            return false;
        }
        DependentWorkflowDefinition other = (DependentWorkflowDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWorkflowDefinitionCode() != other.getWorkflowDefinitionCode()) {
            return false;
        }
        if (this.getWorkflowDefinitionVersion() != other.getWorkflowDefinitionVersion()) {
            return false;
        }
        if (this.getTaskDefinitionCode() != other.getTaskDefinitionCode()) {
            return false;
        }
        String this$taskParams = this.getTaskParams();
        String other$taskParams = other.getTaskParams();
        if (this$taskParams == null ? other$taskParams != null : !this$taskParams.equals(other$taskParams)) {
            return false;
        }
        String this$workerGroup = this.getWorkerGroup();
        String other$workerGroup = other.getWorkerGroup();
        return !(this$workerGroup == null ? other$workerGroup != null : !this$workerGroup.equals(other$workerGroup));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DependentWorkflowDefinition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $workflowDefinitionCode = this.getWorkflowDefinitionCode();
        result = result * 59 + (int)($workflowDefinitionCode >>> 32 ^ $workflowDefinitionCode);
        result = result * 59 + this.getWorkflowDefinitionVersion();
        long $taskDefinitionCode = this.getTaskDefinitionCode();
        result = result * 59 + (int)($taskDefinitionCode >>> 32 ^ $taskDefinitionCode);
        String $taskParams = this.getTaskParams();
        result = result * 59 + ($taskParams == null ? 43 : $taskParams.hashCode());
        String $workerGroup = this.getWorkerGroup();
        result = result * 59 + ($workerGroup == null ? 43 : $workerGroup.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DependentWorkflowDefinition(workflowDefinitionCode=" + this.getWorkflowDefinitionCode() + ", workflowDefinitionVersion=" + this.getWorkflowDefinitionVersion() + ", taskDefinitionCode=" + this.getTaskDefinitionCode() + ", taskParams=" + this.getTaskParams() + ", workerGroup=" + this.getWorkerGroup() + ")";
    }
}

