/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.models.V1ScopeSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourceQuotaSpec defines the desired hard limits to enforce for Quota.")
public class V1ResourceQuotaSpec {
    public static final String SERIALIZED_NAME_HARD = "hard";
    @SerializedName(value="hard")
    private Map<String, Quantity> hard = null;
    public static final String SERIALIZED_NAME_SCOPE_SELECTOR = "scopeSelector";
    @SerializedName(value="scopeSelector")
    private V1ScopeSelector scopeSelector;
    public static final String SERIALIZED_NAME_SCOPES = "scopes";
    @SerializedName(value="scopes")
    private List<String> scopes = null;

    public V1ResourceQuotaSpec hard(Map<String, Quantity> hard) {
        this.hard = hard;
        return this;
    }

    public V1ResourceQuotaSpec putHardItem(String key, Quantity hardItem) {
        if (this.hard == null) {
            this.hard = new HashMap<String, Quantity>();
        }
        this.hard.put(key, hardItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="hard is the set of desired hard limits for each named resource. More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/")
    public Map<String, Quantity> getHard() {
        return this.hard;
    }

    public void setHard(Map<String, Quantity> hard) {
        this.hard = hard;
    }

    public V1ResourceQuotaSpec scopeSelector(V1ScopeSelector scopeSelector) {
        this.scopeSelector = scopeSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ScopeSelector getScopeSelector() {
        return this.scopeSelector;
    }

    public void setScopeSelector(V1ScopeSelector scopeSelector) {
        this.scopeSelector = scopeSelector;
    }

    public V1ResourceQuotaSpec scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public V1ResourceQuotaSpec addScopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A collection of filters that must match each object tracked by a quota. If not specified, the quota matches all objects.")
    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceQuotaSpec v1ResourceQuotaSpec = (V1ResourceQuotaSpec)o;
        return Objects.equals(this.hard, v1ResourceQuotaSpec.hard) && Objects.equals(this.scopeSelector, v1ResourceQuotaSpec.scopeSelector) && Objects.equals(this.scopes, v1ResourceQuotaSpec.scopes);
    }

    public int hashCode() {
        return Objects.hash(this.hard, this.scopeSelector, this.scopes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourceQuotaSpec {\n");
        sb.append("    hard: ").append(this.toIndentedString(this.hard)).append("\n");
        sb.append("    scopeSelector: ").append(this.toIndentedString(this.scopeSelector)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

