/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.authentication.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sagemaker.AmazonSageMaker;
import com.amazonaws.services.sagemaker.AmazonSageMakerClientBuilder;
import java.util.Map;
import lombok.Generated;
import org.apache.dolphinscheduler.authentication.aws.AWSCredentialsProviderFactor;

public final class AmazonSageMakerClientFactory {
    public static AmazonSageMaker createAmazonSageMakerClient(Map<String, String> awsProperties) {
        AWSCredentialsProvider awsCredentialsProvider = AWSCredentialsProviderFactor.credentialsProvider(awsProperties);
        Regions regions = Regions.fromName((String)awsProperties.get("region"));
        String endpoint = awsProperties.get("endpoint");
        if (endpoint != null && !endpoint.isEmpty()) {
            return (AmazonSageMaker)((AmazonSageMakerClientBuilder)((AmazonSageMakerClientBuilder)AmazonSageMakerClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, regions.getName()))).withCredentials(awsCredentialsProvider)).build();
        }
        return (AmazonSageMaker)((AmazonSageMakerClientBuilder)((AmazonSageMakerClientBuilder)AmazonSageMakerClientBuilder.standard().withCredentials(awsCredentialsProvider)).withRegion(regions)).build();
    }

    @Generated
    private AmazonSageMakerClientFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

