/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.Direction;
import com.azure.resourcemanager.network.models.IpFlowProtocol;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class VerificationIpFlowParameters {
    @JsonProperty(value="targetResourceId", required=true)
    private String targetResourceId;
    @JsonProperty(value="direction", required=true)
    private Direction direction;
    @JsonProperty(value="protocol", required=true)
    private IpFlowProtocol protocol;
    @JsonProperty(value="localPort", required=true)
    private String localPort;
    @JsonProperty(value="remotePort", required=true)
    private String remotePort;
    @JsonProperty(value="localIPAddress", required=true)
    private String localIpAddress;
    @JsonProperty(value="remoteIPAddress", required=true)
    private String remoteIpAddress;
    @JsonProperty(value="targetNicResourceId")
    private String targetNicResourceId;
    private static final ClientLogger LOGGER = new ClientLogger(VerificationIpFlowParameters.class);

    public String targetResourceId() {
        return this.targetResourceId;
    }

    public VerificationIpFlowParameters withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    public Direction direction() {
        return this.direction;
    }

    public VerificationIpFlowParameters withDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    public IpFlowProtocol protocol() {
        return this.protocol;
    }

    public VerificationIpFlowParameters withProtocol(IpFlowProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public String localPort() {
        return this.localPort;
    }

    public VerificationIpFlowParameters withLocalPort(String localPort) {
        this.localPort = localPort;
        return this;
    }

    public String remotePort() {
        return this.remotePort;
    }

    public VerificationIpFlowParameters withRemotePort(String remotePort) {
        this.remotePort = remotePort;
        return this;
    }

    public String localIpAddress() {
        return this.localIpAddress;
    }

    public VerificationIpFlowParameters withLocalIpAddress(String localIpAddress) {
        this.localIpAddress = localIpAddress;
        return this;
    }

    public String remoteIpAddress() {
        return this.remoteIpAddress;
    }

    public VerificationIpFlowParameters withRemoteIpAddress(String remoteIpAddress) {
        this.remoteIpAddress = remoteIpAddress;
        return this;
    }

    public String targetNicResourceId() {
        return this.targetNicResourceId;
    }

    public VerificationIpFlowParameters withTargetNicResourceId(String targetNicResourceId) {
        this.targetNicResourceId = targetNicResourceId;
        return this;
    }

    public void validate() {
        if (this.targetResourceId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property targetResourceId in model VerificationIpFlowParameters"));
        }
        if (this.direction() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property direction in model VerificationIpFlowParameters"));
        }
        if (this.protocol() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property protocol in model VerificationIpFlowParameters"));
        }
        if (this.localPort() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property localPort in model VerificationIpFlowParameters"));
        }
        if (this.remotePort() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property remotePort in model VerificationIpFlowParameters"));
        }
        if (this.localIpAddress() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property localIpAddress in model VerificationIpFlowParameters"));
        }
        if (this.remoteIpAddress() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property remoteIpAddress in model VerificationIpFlowParameters"));
        }
    }
}

