/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.region;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.UrlComponentUtils;
import java.io.Serializable;

public class Region
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String regionName;
    private String displayName;

    public Region(String regionName) {
        this(regionName, regionName);
    }

    public Region(String regionName, String displayName) {
        this.regionName = regionName;
        this.displayName = displayName;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof Region) {
            String anotherRegionName = ((Region)anObject).getRegionName();
            return anotherRegionName.equals(this.regionName);
        }
        return false;
    }

    public static String formatRegion(Region region) throws CosClientException {
        return Region.formatRegion(region.getRegionName());
    }

    public static String formatRegion(String regionName) throws CosClientException {
        UrlComponentUtils.validateRegionName(regionName);
        if (regionName.startsWith("cos.")) {
            return regionName;
        }
        if (regionName.equals("cn-east") || regionName.equals("cn-south") || regionName.equals("cn-north") || regionName.equals("cn-south-2") || regionName.equals("cn-southwest") || regionName.equals("sg")) {
            return regionName;
        }
        return "cos." + regionName;
    }

    public static String formatCIRegion(Region region) throws CosClientException {
        return Region.formatCIRegion(region.getRegionName());
    }

    public static String formatCIRegion(String regionName) throws CosClientException {
        UrlComponentUtils.validateRegionName(regionName);
        if (regionName.startsWith("ap-") || regionName.startsWith("eu-") || regionName.startsWith("na-")) {
            return regionName;
        }
        return "ap-" + regionName;
    }
}

