/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.dolphinscheduler.registry.api.Registry;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.apache.dolphinscheduler.registry.api.ha.AbstractHAServer;
import org.apache.dolphinscheduler.registry.api.ha.AbstractServerStatusChangeListener;
import org.apache.dolphinscheduler.registry.api.ha.ServerStatusChangeListener;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.engine.ITaskGroupCoordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MasterCoordinator
extends AbstractHAServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterCoordinator.class);
    private final ITaskGroupCoordinator taskGroupCoordinator;

    public MasterCoordinator(Registry registry, MasterConfig masterConfig, ITaskGroupCoordinator taskGroupCoordinator) {
        super(registry, RegistryNodeType.MASTER_COORDINATOR.getRegistryPath(), masterConfig.getMasterAddress());
        this.taskGroupCoordinator = taskGroupCoordinator;
        this.addServerStatusChangeListener((ServerStatusChangeListener)new MasterCoordinatorListener(taskGroupCoordinator));
    }

    public void start() {
        super.start();
        log.info("MasterCoordinator started...");
    }

    public void close() {
        this.taskGroupCoordinator.close();
        log.info("MasterCoordinator shutdown...");
    }

    public static class MasterCoordinatorListener
    extends AbstractServerStatusChangeListener {
        private final ITaskGroupCoordinator taskGroupCoordinator;

        public MasterCoordinatorListener(ITaskGroupCoordinator taskGroupCoordinator) {
            this.taskGroupCoordinator = (ITaskGroupCoordinator)Preconditions.checkNotNull((Object)taskGroupCoordinator);
        }

        public void changeToActive() {
            this.taskGroupCoordinator.start();
        }

        public void changeToStandBy() {
            this.taskGroupCoordinator.close();
        }
    }
}

