/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.executor.plugin.dependent;

import com.fasterxml.jackson.core.type.TypeReference;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.repository.ProjectDao;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceContextDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowDefinitionDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.parameters.DependentParameters;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.AbstractLogicTask;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.ITaskParameterDeserializer;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.dependent.DependentTaskTracker;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.exception.MasterTaskExecuteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependentLogicTask
extends AbstractLogicTask<DependentParameters> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DependentLogicTask.class);
    private final TaskExecutionContext taskExecutionContext;
    private final DependentTaskTracker dependentTaskTracker;

    public DependentLogicTask(TaskExecutionContext taskExecutionContext, ProjectDao projectDao, WorkflowDefinitionDao workflowDefinitionDao, TaskDefinitionDao taskDefinitionDao, TaskInstanceDao taskInstanceDao, WorkflowInstanceDao workflowInstanceDao, IWorkflowExecutionRunnable workflowExecutionRunnable, TaskInstanceContextDao taskInstanceContextDao) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
        this.dependentTaskTracker = new DependentTaskTracker(taskExecutionContext, (DependentParameters)this.taskParameters, projectDao, workflowDefinitionDao, taskDefinitionDao, taskInstanceDao, workflowInstanceDao, taskInstanceContextDao);
        this.onTaskRunning();
    }

    @Override
    public void start() throws MasterTaskExecuteException {
        log.info("Dependent task: {} started", (Object)this.taskExecutionContext.getTaskName());
    }

    @Override
    public TaskExecutionStatus getTaskExecutionState() {
        if (this.isRunning()) {
            this.taskExecutionStatus = this.dependentTaskTracker.getDependentTaskStatus();
            return this.taskExecutionStatus;
        }
        return this.taskExecutionStatus;
    }

    @Override
    public void pause() throws MasterTaskExecuteException {
        this.onTaskPaused();
        log.info("Pause task : {} success", (Object)this.taskExecutionContext.getTaskName());
    }

    @Override
    public void kill() throws MasterTaskExecuteException {
        this.onTaskKilled();
        log.info("Kill task : {} success", (Object)this.taskExecutionContext.getTaskName());
    }

    @Override
    public ITaskParameterDeserializer<DependentParameters> getTaskParameterDeserializer() {
        return taskParamsJson -> (DependentParameters)JSONUtils.parseObject((String)taskParamsJson, (TypeReference)new TypeReference<DependentParameters>(){});
    }
}

