/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.graph;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.model.SwitchResultVo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.ConditionsParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.SwitchParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.TaskTypeUtils;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowExecutionGraph;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SuccessorFlowAdjuster {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SuccessorFlowAdjuster.class);

    public void adjustSuccessorFlow(ITaskExecutionRunnable taskExecutionRunnable) {
        IWorkflowExecutionGraph workflowExecutionGraph = taskExecutionRunnable.getWorkflowExecutionGraph();
        if (workflowExecutionGraph.isTaskExecutionRunnableSkipped(taskExecutionRunnable)) {
            for (ITaskExecutionRunnable successor : workflowExecutionGraph.getSuccessors(taskExecutionRunnable)) {
                if (!workflowExecutionGraph.isAllPredecessorsSkipped(successor)) continue;
                workflowExecutionGraph.markTaskSkipped(successor);
            }
            return;
        }
        if (workflowExecutionGraph.isTaskExecutionRunnableForbidden(taskExecutionRunnable)) {
            return;
        }
        String taskType = taskExecutionRunnable.getTaskInstance().getTaskType();
        if (TaskTypeUtils.isConditionTask((String)taskType)) {
            this.adjustConditionTaskSuccessorFlow(taskExecutionRunnable);
            return;
        }
        if (TaskTypeUtils.isSwitchTask((String)taskType)) {
            this.adjustSwitchTaskSuccessorFlow(taskExecutionRunnable);
            return;
        }
    }

    private void adjustConditionTaskSuccessorFlow(ITaskExecutionRunnable taskExecutionRunnable) {
        String taskParams = taskExecutionRunnable.getTaskInstance().getTaskParams();
        ConditionsParameters conditionsParameters = (ConditionsParameters)JSONUtils.parseObject((String)taskParams, ConditionsParameters.class);
        if (conditionsParameters == null) {
            throw new IllegalArgumentException("Condition task params: " + taskParams + " is invalid.");
        }
        ConditionsParameters.ConditionResult conditionResult = conditionsParameters.getConditionResult();
        if (conditionResult == null) {
            throw new IllegalArgumentException("ConditionResult: is null in taskParam: " + taskParams);
        }
        List needSkippedBranch = conditionResult.isConditionSuccess() ? conditionResult.getFailedNode() : conditionResult.getSuccessNode();
        this.markTaskSkipped(taskExecutionRunnable, needSkippedBranch);
    }

    private void adjustSwitchTaskSuccessorFlow(ITaskExecutionRunnable taskExecutionRunnable) {
        String taskParams = taskExecutionRunnable.getTaskInstance().getTaskParams();
        SwitchParameters switchParameters = (SwitchParameters)JSONUtils.parseObject((String)taskParams, SwitchParameters.class);
        if (switchParameters == null) {
            throw new IllegalArgumentException("Switch task params: " + taskParams + " is invalid.");
        }
        SwitchParameters.SwitchResult switchResult = switchParameters.getSwitchResult();
        if (switchResult == null) {
            throw new IllegalArgumentException("ConditionResult: is null in taskParam: " + taskParams);
        }
        HashSet<Long> needSkippedBranch = new HashSet<Long>();
        if (switchResult.getNextNode() != null) {
            needSkippedBranch.add(switchResult.getNextNode());
        }
        if (CollectionUtils.isNotEmpty((Collection)switchResult.getDependTaskList())) {
            for (SwitchResultVo switchResultVo : switchResult.getDependTaskList()) {
                needSkippedBranch.add(switchResultVo.getNextNode());
            }
        }
        needSkippedBranch.remove(switchParameters.getNextBranch());
        this.markTaskSkipped(taskExecutionRunnable, needSkippedBranch);
    }

    private void markTaskSkipped(ITaskExecutionRunnable taskExecutionRunnable, Collection<Long> needSkippedTaskCodes) {
        if (CollectionUtils.isEmpty(needSkippedTaskCodes)) {
            return;
        }
        IWorkflowExecutionGraph workflowExecutionGraph = taskExecutionRunnable.getWorkflowExecutionGraph();
        for (Long taskCode : needSkippedTaskCodes) {
            ITaskExecutionRunnable branch = workflowExecutionGraph.getTaskExecutionRunnableByTaskCode(taskCode);
            if (branch == null) {
                log.info("Branch(taskCode={}) is not found in the workflow: {}.", (Object)taskCode, (Object)taskExecutionRunnable.getWorkflowInstance().getName());
                continue;
            }
            workflowExecutionGraph.markTaskSkipped(branch);
        }
    }
}

