/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.client;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.base.utils.Host;
import org.apache.dolphinscheduler.extract.worker.IPhysicalTaskExecutorOperator;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.master.cluster.loadbalancer.IWorkerLoadBalancer;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.engine.task.client.ITaskExecutorClientDelegator;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.exception.dispatch.TaskDispatchException;
import org.apache.dolphinscheduler.task.executor.eventbus.ITaskExecutorLifecycleEventReporter;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorDispatchRequest;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorDispatchResponse;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorKillRequest;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorKillResponse;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorPauseRequest;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorPauseResponse;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorReassignMasterRequest;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorReassignMasterResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PhysicalTaskExecutorClientDelegator
implements ITaskExecutorClientDelegator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PhysicalTaskExecutorClientDelegator.class);
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private IWorkerLoadBalancer workerLoadBalancer;

    @Override
    public void dispatch(ITaskExecutionRunnable taskExecutionRunnable) throws TaskDispatchException {
        TaskExecutionContext taskExecutionContext = taskExecutionRunnable.getTaskExecutionContext();
        String taskName = taskExecutionContext.getTaskName();
        String physicalTaskExecutorAddress = this.workerLoadBalancer.select(taskExecutionContext.getWorkerGroup()).map(Host::of).map(Host::getAddress).orElseThrow(() -> new TaskDispatchException(String.format("Cannot find the host to dispatch Task[id=%s, name=%s, workerGroup=%s]", taskExecutionContext.getTaskInstanceId(), taskName, taskExecutionContext.getWorkerGroup())));
        taskExecutionContext.setHost(physicalTaskExecutorAddress);
        taskExecutionRunnable.getTaskInstance().setHost(physicalTaskExecutorAddress);
        try {
            TaskExecutorDispatchResponse taskExecutorDispatchResponse = ((IPhysicalTaskExecutorOperator)Clients.withService(IPhysicalTaskExecutorOperator.class).withHost(physicalTaskExecutorAddress)).dispatchTask(TaskExecutorDispatchRequest.of((TaskExecutionContext)taskExecutionRunnable.getTaskExecutionContext()));
            if (!taskExecutorDispatchResponse.isDispatchSuccess()) {
                throw new TaskDispatchException("Dispatch task: " + taskName + " to " + physicalTaskExecutorAddress + " failed: " + taskExecutorDispatchResponse);
            }
        }
        catch (TaskDispatchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TaskDispatchException("Dispatch task: " + taskName + " to " + physicalTaskExecutorAddress + " failed", e);
        }
    }

    @Override
    public boolean reassignMasterHost(ITaskExecutionRunnable taskExecutionRunnable) {
        String taskName = taskExecutionRunnable.getName();
        Preconditions.checkArgument((boolean)taskExecutionRunnable.isTaskInstanceInitialized(), (Object)("Task " + taskName + "is not initialized cannot take-over"));
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        String taskExecutorHost = taskInstance.getHost();
        if (StringUtils.isEmpty((CharSequence)taskExecutorHost)) {
            log.debug("The task executor: {} host is empty, cannot take-over, this might caused by the task hasn't dispatched", (Object)taskName);
            return false;
        }
        TaskExecutorReassignMasterRequest taskExecutorReassignMasterRequest = TaskExecutorReassignMasterRequest.builder().taskInstanceId(taskInstance.getId().intValue()).workflowHost(this.masterConfig.getMasterAddress()).build();
        TaskExecutorReassignMasterResponse taskExecutorReassignMasterResponse = ((IPhysicalTaskExecutorOperator)Clients.withService(IPhysicalTaskExecutorOperator.class).withHost(taskInstance.getHost())).reassignWorkflowInstanceHost(taskExecutorReassignMasterRequest);
        boolean success = taskExecutorReassignMasterResponse.isSuccess();
        if (success) {
            log.info("Reassign master host {} to {} successfully", (Object)taskExecutorHost, (Object)taskName);
        } else {
            log.info("Reassign master host {} on {} failed with response {}", new Object[]{taskExecutorHost, taskName, taskExecutorReassignMasterResponse});
        }
        return success;
    }

    @Override
    public void pause(ITaskExecutionRunnable taskExecutionRunnable) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        String executorHost = taskInstance.getHost();
        String taskName = taskInstance.getName();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)executorHost), (Object)"Executor host is empty");
        TaskExecutorPauseResponse pauseResponse = ((IPhysicalTaskExecutorOperator)Clients.withService(IPhysicalTaskExecutorOperator.class).withHost(taskInstance.getHost())).pauseTask(TaskExecutorPauseRequest.of((Integer)taskInstance.getId()));
        if (pauseResponse.isSuccess()) {
            log.info("Pause task {} on executor {} successfully", (Object)taskName, (Object)executorHost);
        } else {
            log.warn("Pause task {} on executor {} failed with response {}", new Object[]{taskName, executorHost, pauseResponse});
        }
    }

    @Override
    public void kill(ITaskExecutionRunnable taskExecutionRunnable) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        String executorHost = taskInstance.getHost();
        String taskName = taskInstance.getName();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)executorHost), (Object)"Executor host is empty");
        TaskExecutorKillResponse killResponse = ((IPhysicalTaskExecutorOperator)Clients.withService(IPhysicalTaskExecutorOperator.class).withHost(executorHost)).killTask(TaskExecutorKillRequest.of((Integer)taskInstance.getId()));
        if (killResponse.isSuccess()) {
            log.info("Kill task {} on executor {} successfully", (Object)taskName, (Object)executorHost);
        } else {
            log.warn("Kill task {} on executor {} failed with response {}", new Object[]{taskName, executorHost, killResponse});
        }
    }

    @Override
    public void ackTaskExecutorLifecycleEvent(ITaskExecutionRunnable taskExecutionRunnable, ITaskExecutorLifecycleEventReporter.TaskExecutorLifecycleEventAck taskExecutorLifecycleEventAck) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        String executorHost = taskInstance.getHost();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)executorHost), (Object)"Executor host is empty");
        ((IPhysicalTaskExecutorOperator)Clients.withService(IPhysicalTaskExecutorOperator.class).withHost(executorHost)).ackPhysicalTaskExecutorLifecycleEvent(taskExecutorLifecycleEventAck);
    }
}

