/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.runnable;

import java.util.List;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.server.master.engine.WorkflowEventBus;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowExecutionGraph;
import org.apache.dolphinscheduler.server.master.engine.workflow.listener.IWorkflowLifecycleListener;
import org.apache.dolphinscheduler.server.master.runner.IWorkflowExecuteContext;

public interface IWorkflowExecutionRunnable {
    default public int getId() {
        return this.getWorkflowInstance().getId();
    }

    default public String getName() {
        return this.getWorkflowInstance().getName();
    }

    public void pause();

    default public boolean isWorkflowReadyPause() {
        WorkflowExecutionStatus workflowExecutionStatus = this.getWorkflowInstance().getState();
        return workflowExecutionStatus == WorkflowExecutionStatus.READY_PAUSE;
    }

    public void stop();

    default public boolean isWorkflowReadyStop() {
        WorkflowExecutionStatus workflowExecutionStatus = this.getWorkflowInstance().getState();
        return workflowExecutionStatus == WorkflowExecutionStatus.READY_STOP;
    }

    public IWorkflowExecuteContext getWorkflowExecuteContext();

    default public WorkflowInstance getWorkflowInstance() {
        return this.getWorkflowExecuteContext().getWorkflowInstance();
    }

    default public WorkflowExecutionStatus getState() {
        return this.getWorkflowInstance().getState();
    }

    default public WorkflowEventBus getWorkflowEventBus() {
        return this.getWorkflowExecuteContext().getWorkflowEventBus();
    }

    default public IWorkflowExecutionGraph getWorkflowExecutionGraph() {
        return this.getWorkflowExecuteContext().getWorkflowExecutionGraph();
    }

    public List<IWorkflowLifecycleListener> getWorkflowLifecycleListeners();

    public void registerWorkflowInstanceLifecycleListener(IWorkflowLifecycleListener var1);
}

